/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.display;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.UIDialogHandler;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.DisplayEvent;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.service.Display;
import com.almasb.fxgl.service.EventBus;
import com.almasb.fxgl.service.impl.display.DialogPane;
import com.almasb.fxgl.service.impl.display.FXGLDisplay$initStage$;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.settings.SceneDimension;
import com.almasb.fxgl.settings.UserProfile;
import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J,\u0010'\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u000b0\u000b \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010(0(H\u0016J\u0010\u0010)\u001a\n \u0015*\u0004\u0018\u00010*0*H\u0016J\b\u0010+\u001a\u00020%H\u0016J\u0006\u0010,\u001a\u00020%J\u0006\u0010-\u001a\u00020%J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u001c0\u001c0\u001bH\u0016J\u0006\u0010/\u001a\u00020%J\u0006\u00100\u001a\u00020%J\b\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020\"H\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\u000bH\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u00104\u001a\u000205H\u0016J\b\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020\"2\u0006\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%H\u0002J\u0010\u0010>\u001a\u00020\"2\u0006\u00107\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020\u001cH\u0016J1\u0010A\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0G\"\u00020HH\u0016\u00a2\u0006\u0002\u0010IJ\u001e\u0010J\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020:0LH\u0016J*\u0010M\u001a\u00020\"\"\u0004\b\u0000\u0010N2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002HN0O2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HN0LH\u0016J\u0018\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u00020C2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010P\u001a\u00020\"2\u0006\u0010T\u001a\u00020UH\u0016J\u001e\u0010V\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020C0LH\u0016J,\u0010V\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020C0X2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020C0LH\u0016J,\u0010Y\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020C0X2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020C0LH\u0016J\u0010\u0010Z\u001a\u00020\"2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010Z\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010[\u001a\u00020\\2\u0006\u0010B\u001a\u00020CH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/almasb/fxgl/service/impl/display/FXGLDisplay;", "Lcom/almasb/fxgl/service/Display;", "stage", "Ljavafx/stage/Stage;", "fxScene", "Ljavafx/scene/Scene;", "(Ljavafx/stage/Stage;Ljavafx/scene/Scene;)V", "css", "Lcom/almasb/fxgl/scene/CSS;", "currentScene", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "Lcom/almasb/fxgl/scene/FXGLScene;", "dialog", "Lcom/almasb/fxgl/service/impl/display/DialogPane;", "eventBus", "Lcom/almasb/fxgl/service/EventBus;", "fxToFXGLFilter", "Ljavafx/event/EventHandler;", "Ljavafx/event/Event;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "scaleRatio", "Ljavafx/beans/property/DoubleProperty;", "scaledHeight", "scaledWidth", "sceneDimensions", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/settings/SceneDimension;", "settings", "Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;", "targetHeight", "targetWidth", "computeScaledSize", "", "computeSceneSettings", "width", "", "height", "currentSceneProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "getBounds", "Ljavafx/geometry/Rectangle2D;", "getScaleRatio", "getScaledHeight", "getScaledWidth", "getSceneDimensions", "getTargetHeight", "getTargetWidth", "initDialogBox", "initStage", "load", "profile", "Lcom/almasb/fxgl/settings/UserProfile;", "registerScene", "scene", "save", "saveScreenshot", "", "setNewResolution", "w", "h", "setScene", "setSceneDimension", "dimension", "showBox", "message", "", "content", "Ljavafx/scene/Node;", "buttons", "", "Ljavafx/scene/control/Button;", "(Ljava/lang/String;Ljavafx/scene/Node;[Ljavafx/scene/control/Button;)V", "showConfirmationBox", "resultCallback", "Ljava/util/function/Consumer;", "showDialog", "T", "Ljavafx/scene/control/Dialog;", "showErrorBox", "errorMessage", "callback", "Ljava/lang/Runnable;", "error", "", "showInputBox", "filter", "Ljava/util/function/Predicate;", "showInputBoxWithCancel", "showMessageBox", "showProgressBox", "Lcom/almasb/fxgl/io/UIDialogHandler;", "fxgl"})
public final class FXGLDisplay
implements Display {
    private final Logger log;
    private final ReadOnlyObjectWrapper<FXGLScene> currentScene;
    private final DoubleProperty targetWidth;
    private final DoubleProperty targetHeight;
    private final DoubleProperty scaledWidth;
    private final DoubleProperty scaledHeight;
    private final DoubleProperty scaleRatio;
    private final CSS css;
    private final EventBus eventBus;
    private final ReadOnlyGameSettings settings;
    private final ArrayList<SceneDimension> sceneDimensions;
    private final EventHandler<Event> fxToFXGLFilter;
    private DialogPane dialog;
    private final Stage stage;
    private Scene fxScene;

    private final void initStage() {
        Stage stage;
        Stage $receiver = stage = this.stage;
        $receiver.setTitle(this.settings.getTitle() + " " + this.settings.getVersion());
        $receiver.setResizable(false);
        $receiver.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ FXGLDisplay this$0;
            {
                this.this$0 = fXGLDisplay;
            }

            public final void handle(WindowEvent e) {
                e.consume();
                if (FXGLDisplay.access$getSettings$p(this.this$0).isCloseConfirmation()) {
                    if (!FXGLDisplay.access$getDialog$p(this.this$0).isShowing()) {
                        this.this$0.showConfirmationBox("Exit the game?", new Consumer<Boolean>(this){
                            final /* synthetic */ initStage$$inlined$with$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void accept(Boolean yes) {
                                Boolean bl = yes;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                                if (bl.booleanValue()) {
                                    FXGLDisplay.access$getEventBus$p(this.this$0.this$0).fireEvent(new DisplayEvent(DisplayEvent.CLOSE_REQUEST));
                                }
                            }
                        });
                    }
                } else {
                    FXGLDisplay.access$getEventBus$p(this.this$0).fireEvent(new DisplayEvent(DisplayEvent.CLOSE_REQUEST));
                }
            }
        });
        $receiver.setOnShown((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ FXGLDisplay this$0;
            {
                this.this$0 = fXGLDisplay;
            }

            public final void handle(WindowEvent it) {
                FXGLDisplay.access$getLog$p(this.this$0).debug("Showing stage");
                FXGLDisplay.access$getLog$p(this.this$0).debug("Root size: " + FXGLDisplay.access$getStage$p(this.this$0).getScene().getRoot().getLayoutBounds().getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getScene().getRoot().getLayoutBounds().getHeight());
                FXGLDisplay.access$getLog$p(this.this$0).debug("Scene size: " + FXGLDisplay.access$getStage$p(this.this$0).getScene().getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getScene().getHeight());
                FXGLDisplay.access$getLog$p(this.this$0).debug("Stage size: " + FXGLDisplay.access$getStage$p(this.this$0).getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getHeight());
            }
        });
        $receiver.getIcons().add((Object)FXGLAssets.UI_ICON);
        if (this.settings.isFullScreen()) {
            $receiver.setFullScreenExitHint("");
            $receiver.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            $receiver.setFullScreen(true);
        }
        $receiver.sizeToScene();
        $receiver.centerOnScreen();
    }

    @Override
    public void registerScene(@NotNull FXGLScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        scene.bindSize(this.scaledWidth, this.scaledHeight, this.scaleRatio);
        scene.appendCSS(this.css);
    }

    @Override
    public void setScene(@NotNull FXGLScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        FXGLScene fXGLScene = this.getCurrentScene();
        if (fXGLScene != null && (fXGLScene = fXGLScene.activeProperty()) != null) {
            fXGLScene.set(false);
        }
        this.currentScene.set((Object)scene);
        scene.activeProperty().set(true);
        this.fxScene.setRoot((Parent)scene.getRoot());
    }

    @Override
    public ReadOnlyObjectProperty<FXGLScene> currentSceneProperty() {
        return this.currentScene.getReadOnlyProperty();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.settings.isFullScreen() ? Screen.getPrimary().getBounds() : Screen.getPrimary().getVisualBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveScreenshot() {
        WritableImage fxImage = this.fxScene.snapshot(null);
        String fileName = "./" + this.settings.getTitle() + this.settings.getVersion() + LocalDateTime.now();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        BufferedImage img = SwingFXUtils.fromFXImage((Image)((Image)fxImage), null);
        try {
            Closeable closeable = Files.newOutputStream(Paths.get(fileName + ".png", new String[0]), new OpenOption[0]);
            boolean bl = false;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = ImageIO.write((RenderedImage)img, "png", it);
                return bl2;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot() failed: " + e);
            return false;
        }
    }

    @NotNull
    public ArrayList<SceneDimension> getSceneDimensions() {
        return new ArrayList<SceneDimension>((Collection)this.sceneDimensions);
    }

    private final void computeSceneSettings(double width, double height) {
        int it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Rectangle2D bounds = this.getBounds();
        double ratio = width / height;
        int[] nArray = new int[]{360, 480, 720, 1080};
        ArrayList<SceneDimension> arrayList = this.sceneDimensions;
        void var9_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            it = element$iv$iv;
            if (!((double)it <= bounds.getHeight() && (double)it * ratio <= bounds.getWidth())) continue;
            destination$iv$iv.add((int)element$iv$iv);
        }
        Collection<SceneDimension> collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            SceneDimension sceneDimension = new SceneDimension((double)it * ratio, it);
            collection.add(sceneDimension);
        }
        collection = (List)destination$iv$iv;
        arrayList.addAll(collection);
    }

    public final double getTargetWidth() {
        return this.targetWidth.get();
    }

    public final double getTargetHeight() {
        return this.targetHeight.get();
    }

    public final double getScaledWidth() {
        return this.scaledWidth.get();
    }

    public final double getScaledHeight() {
        return this.scaledHeight.get();
    }

    @Override
    public double getScaleRatio() {
        return this.scaleRatio.get();
    }

    /*
     * WARNING - void declaration
     */
    private final void computeScaledSize() {
        double newW = this.getTargetWidth();
        double newH = this.getTargetHeight();
        Rectangle2D bounds = this.getBounds();
        if (newW > bounds.getWidth() || newH > bounds.getHeight()) {
            this.log.debug("App size > screen size");
            double ratio = newW / newH;
            int n = (int)bounds.getWidth();
            int n2 = 1;
            if (n >= n2) {
                while (true) {
                    void newWidth;
                    if ((double)newWidth / ratio <= bounds.getHeight()) {
                        newW = (double)newWidth;
                        newH = (double)newWidth / ratio;
                        break;
                    }
                    if (newWidth == n2) break;
                    --newWidth;
                }
            }
        }
        this.scaledWidth.set(newW);
        this.scaledHeight.set(newH);
        this.scaleRatio.set(newW / (double)this.settings.getWidth());
        this.log.debug("Target size: " + this.targetWidth + " x " + this.targetHeight + " @ 1.0");
        this.log.debug("New size:    " + newW + " x " + newH + " @ " + this.scaleRatio);
    }

    private final void setNewResolution(double w, double h) {
        this.targetWidth.set(w);
        this.targetHeight.set(h);
        this.computeScaledSize();
        Parent root = this.fxScene.getRoot();
        this.fxScene.removeEventFilter(EventType.ROOT, this.fxToFXGLFilter);
        this.fxScene.setRoot((Parent)new Pane());
        this.fxScene = new Scene(root);
        this.fxScene.addEventFilter(EventType.ROOT, this.fxToFXGLFilter);
        this.stage.setScene(this.fxScene);
        if (this.settings.isFullScreen()) {
            this.stage.setFullScreen(true);
        }
    }

    @Override
    public void setSceneDimension(@NotNull SceneDimension dimension) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dimension), (String)"dimension");
        if (this.sceneDimensions.contains((Object)dimension)) {
            this.log.debug((Supplier)new Supplier<String>(dimension){
                final /* synthetic */ SceneDimension $dimension;

                @NotNull
                public final String get() {
                    return "Setting scene dimension: " + (Object)((Object)this.$dimension);
                }
                {
                    this.$dimension = sceneDimension;
                }
            });
            this.setNewResolution(dimension.getWidth(), dimension.getHeight());
        } else {
            this.log.warning((Supplier)new Supplier<String>(dimension){
                final /* synthetic */ SceneDimension $dimension;

                @NotNull
                public final String get() {
                    return (Object)((Object)this.$dimension) + " is not supported!";
                }
                {
                    this.$dimension = sceneDimension;
                }
            });
        }
    }

    private final void initDialogBox() {
        DialogPane dialogPane = this.dialog = new DialogPane(this);
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.setOnShown$fxgl(new Runnable(this){
            final /* synthetic */ FXGLDisplay this$0;

            public final void run() {
                FXGLDisplay.access$getFxScene$p(this.this$0).removeEventFilter(EventType.ROOT, FXGLDisplay.access$getFxToFXGLFilter$p(this.this$0));
                FXGLDisplay.access$getEventBus$p(this.this$0).fireEvent(new DisplayEvent(DisplayEvent.DIALOG_OPENED));
            }
            {
                this.this$0 = fXGLDisplay;
            }
        });
        DialogPane dialogPane2 = this.dialog;
        if (dialogPane2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane2.setOnClosed$fxgl(new Runnable(this){
            final /* synthetic */ FXGLDisplay this$0;

            public final void run() {
                FXGLDisplay.access$getEventBus$p(this.this$0).fireEvent(new DisplayEvent(DisplayEvent.DIALOG_CLOSED));
                FXGLDisplay.access$getFxScene$p(this.this$0).addEventFilter(EventType.ROOT, FXGLDisplay.access$getFxToFXGLFilter$p(this.this$0));
            }
            {
                this.this$0 = fXGLDisplay;
            }
        });
    }

    @Override
    public <T> void showDialog(@NotNull Dialog<T> dialog, @NotNull Consumer<T> resultCallback) {
        Intrinsics.checkParameterIsNotNull(dialog, (String)"dialog");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        this.eventBus.fireEvent(new DisplayEvent(DisplayEvent.DIALOG_OPENED));
        dialog.initOwner((Window)this.stage);
        dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(this, resultCallback, dialog){
            final /* synthetic */ FXGLDisplay this$0;
            final /* synthetic */ Consumer $resultCallback;
            final /* synthetic */ Dialog $dialog;

            public final void handle(DialogEvent e) {
                FXGLDisplay.access$getEventBus$p(this.this$0).fireEvent(new DisplayEvent(DisplayEvent.DIALOG_CLOSED));
                this.$resultCallback.accept(this.$dialog.getResult());
            }
            {
                this.this$0 = fXGLDisplay;
                this.$resultCallback = consumer;
                this.$dialog = dialog;
            }
        });
        dialog.show();
    }

    @Override
    public void showMessageBox(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        DialogPane.showMessageBox$fxgl$default(dialogPane, message, null, 2, null);
    }

    @Override
    public void showMessageBox(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showMessageBox$fxgl(message, callback);
    }

    @Override
    public void showConfirmationBox(@NotNull String message, @NotNull Consumer<Boolean> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showConfirmationBox$fxgl(message, resultCallback);
    }

    @Override
    public void showInputBox(@NotNull String message, @NotNull Consumer<String> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showInputBox$fxgl(message, resultCallback);
    }

    @Override
    public void showInputBox(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showInputBox$fxgl(message, filter, resultCallback);
    }

    @Override
    public void showInputBoxWithCancel(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showInputBoxWithCancel$fxgl(message, filter, resultCallback);
    }

    @Override
    public void showErrorBox(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        DialogPane.showErrorBox$fxgl$default(dialogPane, error, null, 2, null);
    }

    @Override
    public void showErrorBox(@NotNull String errorMessage, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showErrorBox$fxgl(errorMessage, callback);
    }

    @Override
    public void showBox(@NotNull String message, @NotNull Node content, Button ... buttons) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)buttons, (String)"buttons");
        DialogPane dialogPane = this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        dialogPane.showBox$fxgl(message, content, Arrays.copyOf(buttons, buttons.length));
    }

    @Override
    @NotNull
    public UIDialogHandler showProgressBox(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefSize(200.0, 200.0);
        Button btn = new Button();
        btn.setVisible(false);
        this.showBox(message, (Node)progress, btn);
        return new UIDialogHandler(btn){
            final /* synthetic */ Button $btn;

            public void show() {
            }

            public void dismiss() {
                this.$btn.fire();
            }
            {
                this.$btn = $captured_local_variable$0;
            }
        };
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("scene");
        bundle.put("sizeW", (Serializable)Double.valueOf(this.getTargetWidth()));
        bundle.put("sizeH", (Serializable)Double.valueOf(this.getTargetHeight()));
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("scene");
        bundle.log();
        this.setNewResolution(((Number)bundle.get("sizeW")).doubleValue(), ((Number)bundle.get("sizeH")).doubleValue());
    }

    @Inject
    private FXGLDisplay(Stage stage, Scene fxScene) {
        CSS cSS;
        this.stage = stage;
        this.fxScene = fxScene;
        this.log = FXGL.Companion.getLogger(this.getClass());
        this.currentScene = new ReadOnlyObjectWrapper();
        this.sceneDimensions = new ArrayList();
        this.fxToFXGLFilter = (EventHandler)new EventHandler<Event>(this){
            final /* synthetic */ FXGLDisplay this$0;

            public final void handle(Event event) {
                block0: {
                    Event copy = event.copyFor(null, null);
                    FXGLScene fXGLScene = this.this$0.getCurrentScene();
                    if (fXGLScene == null) break block0;
                    fXGLScene.fireEvent(copy);
                }
            }
            {
                this.this$0 = fXGLDisplay;
            }
        };
        ReadOnlyGameSettings readOnlyGameSettings = FXGL.Companion.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyGameSettings, (String)"FXGL.getSettings()");
        this.settings = readOnlyGameSettings;
        this.targetWidth = (DoubleProperty)new SimpleDoubleProperty((double)this.settings.getWidth());
        this.targetHeight = (DoubleProperty)new SimpleDoubleProperty((double)this.settings.getHeight());
        this.scaledWidth = (DoubleProperty)new SimpleDoubleProperty();
        this.scaledHeight = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatio = (DoubleProperty)new SimpleDoubleProperty();
        if (FXGLAssets.UI_CSS.isDefault()) {
            CSS cSS2 = FXGL.Companion.getAssetLoader().loadCSS(this.settings.getMenuStyle().getCSSFileName());
            cSS = cSS2;
            Intrinsics.checkExpressionValueIsNotNull((Object)cSS2, (String)"FXGL.getAssetLoader().lo\u2026gs.menuStyle.cssFileName)");
        } else {
            cSS = FXGLAssets.UI_CSS;
        }
        this.css = cSS;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public final void run() {
                this.initStage();
            }
        });
        this.initDialogBox();
        this.fxScene.addEventFilter(EventType.ROOT, this.fxToFXGLFilter);
        this.computeSceneSettings(this.settings.getWidth(), this.settings.getHeight());
        this.computeScaledSize();
        EventBus eventBus = FXGL.Companion.getEventBus();
        Intrinsics.checkExpressionValueIsNotNull((Object)eventBus, (String)"FXGL.getEventBus()");
        this.eventBus = eventBus;
        this.log.debug((Supplier)2.INSTANCE);
        this.log.debug((Supplier)new Supplier<String>(){

            @Override
            @NotNull
            public final String get() {
                return "Using CSS: " + css;
            }
        });
    }

    @NotNull
    public static final /* synthetic */ ReadOnlyGameSettings access$getSettings$p(FXGLDisplay $this) {
        return $this.settings;
    }

    @NotNull
    public static final /* synthetic */ DialogPane access$getDialog$p(FXGLDisplay $this) {
        DialogPane dialogPane = $this.dialog;
        if (dialogPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
        }
        return dialogPane;
    }

    public static final /* synthetic */ void access$setDialog$p(FXGLDisplay $this, @NotNull DialogPane dialogPane) {
        $this.dialog = dialogPane;
    }

    @NotNull
    public static final /* synthetic */ EventBus access$getEventBus$p(FXGLDisplay $this) {
        return $this.eventBus;
    }

    public static final /* synthetic */ Logger access$getLog$p(FXGLDisplay $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ Stage access$getStage$p(FXGLDisplay $this) {
        return $this.stage;
    }

    @NotNull
    public static final /* synthetic */ Scene access$getFxScene$p(FXGLDisplay $this) {
        return $this.fxScene;
    }

    public static final /* synthetic */ void access$setFxScene$p(FXGLDisplay $this, @NotNull Scene scene) {
        $this.fxScene = scene;
    }

    @NotNull
    public static final /* synthetic */ EventHandler access$getFxToFXGLFilter$p(FXGLDisplay $this) {
        return $this.fxToFXGLFilter;
    }
}

