/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.pooler;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.service.Pooler;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0003\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J.\u0010\u0011\u001a\u00020\u000f\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0013H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/service/impl/pooler/FXGLPooler;", "Lcom/almasb/fxgl/service/Pooler;", "initialSize", "", "(I)V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "kotlin.jvm.PlatformType", "get", "T", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "put", "", "object", "registerPool", "pool", "Lcom/almasb/fxgl/core/pool/Pool;", "fxgl"})
public final class FXGLPooler
implements Pooler {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());

    @Override
    @NotNull
    public <T> T get(@NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Object object = Pools.obtain(type);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Pools.obtain(type)");
        return (T)object;
    }

    @Override
    public void put(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        Pools.free((Object)object);
    }

    @Override
    public <T> void registerPool(@NotNull Class<T> type, @NotNull Pool<T> pool) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        Pools.set(type, pool);
    }

    @Inject
    private FXGLPooler(final @Named(value="pooling.initialSize") int initialSize) {
        this.registerPool(Vec2.class, (Pool)new Pool<Vec2>(initialSize){

            @NotNull
            protected Vec2 newObject() {
                return new Vec2();
            }
        });
        this.log.debug("Service [Pooler] initialized with default size = " + initialSize);
    }
}

