/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.annotation.AddCollisionHandler;
import com.almasb.fxgl.annotation.SetEntityFactory;
import com.almasb.fxgl.app.AppState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.LoadingScene;
import com.almasb.fxgl.scene.SceneFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/app/LoadingState;", "Lcom/almasb/fxgl/app/AppState;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "sceneFactory", "Lcom/almasb/fxgl/scene/SceneFactory;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/scene/SceneFactory;)V", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "getDataFile", "()Lcom/almasb/fxgl/saving/DataFile;", "setDataFile", "(Lcom/almasb/fxgl/saving/DataFile;)V", "loadingFinished", "", "onEnter", "", "prevState", "Lcom/almasb/fxgl/app/State;", "onUpdate", "tpf", "", "InitAppTask", "fxgl"})
public final class LoadingState
extends AppState {
    @NotNull
    private DataFile dataFile;
    private boolean loadingFinished;
    private final GameApplication app;

    @NotNull
    public final DataFile getDataFile() {
        return this.dataFile;
    }

    public final void setDataFile(@NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"<set-?>");
        this.dataFile = dataFile;
    }

    @Override
    protected void onEnter(@NotNull State prevState) {
        Intrinsics.checkParameterIsNotNull((Object)prevState, (String)"prevState");
        InitAppTask initTask = new InitAppTask(FXGL.Companion.getApp(), this.dataFile);
        initTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(this){
            final /* synthetic */ LoadingState this$0;

            public final void handle(WorkerStateEvent it) {
                LoadingState.access$setLoadingFinished$p(this.this$0, true);
            }
            {
                this.this$0 = loadingState;
            }
        });
        this.dataFile = DataFile.Companion.getEMPTY();
        FXGLScene fXGLScene = this.getScene();
        if (fXGLScene == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.scene.LoadingScene");
        }
        ((LoadingScene)fXGLScene).bind(initTask);
        FXGL.Companion.getExecutor().execute((Runnable)((Object)initTask));
    }

    @Override
    protected void onUpdate(double tpf) {
        if (this.loadingFinished) {
            this.app.getStateMachine().startPlay();
            this.loadingFinished = false;
        }
    }

    @Inject
    private LoadingState(GameApplication app, SceneFactory sceneFactory) {
        super(sceneFactory.newLoadingScene());
        this.app = app;
        this.dataFile = DataFile.Companion.getEMPTY();
    }

    public static final /* synthetic */ boolean access$getLoadingFinished$p(LoadingState $this) {
        return $this.loadingFinished;
    }

    public static final /* synthetic */ void access$setLoadingFinished$p(LoadingState $this, boolean bl) {
        $this.loadingFinished = bl;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u000b\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000e0\fH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/app/LoadingState$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/saving/DataFile;)V", "call", "failed", "", "scanForAnnotations", "", "Ljava/lang/Class;", "", "update", "message", "", "step", "", "Companion", "fxgl"})
    private static final class InitAppTask
    extends Task<Void> {
        private final GameApplication app;
        private final DataFile dataFile;
        private static final Logger log;
        public static final Companion Companion;

        @Nullable
        protected Void call() {
            List<Class<?>> it;
            List<Class<?>> list;
            long start2 = System.nanoTime();
            InitAppTask.Companion.getLog().debug("Clearing game world");
            this.app.getGameWorld().reset();
            this.update("Initializing Assets", 0);
            this.app.initAssets();
            this.update("Initializing Game", 1);
            InitAppTask.Companion.getLog().debug("Clearing game state");
            this.app.getGameState().clear();
            HashMap vars = new HashMap();
            this.app.initGameVars(vars);
            vars.forEach((BiConsumer)new BiConsumer<String, Object>(this){
                final /* synthetic */ InitAppTask this$0;

                public final void accept(@NotNull String name, @NotNull Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    GameState gameState = InitAppTask.access$getApp$p(this.this$0).getGameState();
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    Object object = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                    gameState.put(string, object);
                }
                {
                    this.this$0 = initAppTask;
                }
            });
            Map<Class<?>, List<Class<?>>> annotationMap = this.scanForAnnotations();
            List<Class<?>> list2 = annotationMap.get(SetEntityFactory.class);
            if (list2 != null) {
                list = list2;
                it = list;
                Collection collection = it;
                if (!collection.isEmpty()) {
                    Object obj = FXGL.Companion.getInstance(it.get(0));
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.entity.EntityFactory");
                    }
                    this.app.getGameWorld().setEntityFactory((EntityFactory)obj);
                }
            }
            if (this.dataFile == DataFile.Companion.getEMPTY()) {
                this.app.initGame();
            } else {
                this.app.loadState(this.dataFile);
            }
            this.update("Initializing Physics", 2);
            this.app.initPhysics();
            List<Class<?>> list3 = annotationMap.get(AddCollisionHandler.class);
            if (list3 != null) {
                it = list = list3;
                Iterable $receiver$iv = it;
                for (Object element$iv : $receiver$iv) {
                    Class it2 = (Class)element$iv;
                    Object t = FXGL.Companion.getInstance(it2);
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.physics.CollisionHandler");
                    }
                    CollisionHandler handler2 = (CollisionHandler)t;
                    InitAppTask.Companion.getLog().debug("@Add " + handler2);
                    this.app.getPhysicsWorld().addCollisionHandler(handler2);
                }
            }
            this.update("Initializing UI", 3);
            this.app.initUI();
            this.update("Initialization Complete", 4);
            InitAppTask.Companion.getLog().infof("Game initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - start2) / 1.0E9});
            return null;
        }

        private final void update(String message, int step) {
            InitAppTask.Companion.getLog().debug(message);
            this.updateMessage(message);
            this.updateProgress(step, 4L);
        }

        protected void failed() {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread thread = Thread.currentThread();
            Throwable throwable = this.getException();
            if (throwable == null) {
                throwable = new RuntimeException("Initialization failed");
            }
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
        }

        private final Map<Class<?>, List<Class<?>>> scanForAnnotations() {
            HashMap map = new HashMap();
            if (((Object)((Object)this.app)).getClass().getPackage() != null) {
                FastClasspathScanner scanner = new FastClasspathScanner(new String[]{((Object)((Object)this.app)).getClass().getPackage().getName()});
                Map map2 = map;
                Class clazz = SetEntityFactory.class;
                ArrayList arrayList = new ArrayList();
                map2.put(clazz, arrayList);
                scanner.matchClassesWithAnnotation(SetEntityFactory.class, new ClassAnnotationMatchProcessor(map){
                    final /* synthetic */ HashMap $map;

                    public final void processMatch(Class<?> it) {
                        Companion.access$getLog$p(InitAppTask.Companion).debug("@SetEntityFactory: " + it);
                        V v = this.$map.get(SetEntityFactory.class);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        ((ArrayList)v).add(it);
                    }
                    {
                        this.$map = hashMap;
                    }
                });
                map2 = map;
                clazz = AddCollisionHandler.class;
                arrayList = new ArrayList();
                map2.put(clazz, arrayList);
                scanner.matchClassesWithAnnotation(AddCollisionHandler.class, new ClassAnnotationMatchProcessor(map){
                    final /* synthetic */ HashMap $map;

                    public final void processMatch(Class<?> it) {
                        Companion.access$getLog$p(InitAppTask.Companion).debug("@AddCollisionHandler: " + it);
                        V v = this.$map.get(AddCollisionHandler.class);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        ((ArrayList)v).add(it);
                    }
                    {
                        this.$map = hashMap;
                    }
                });
                scanner.scan();
            } else {
                InitAppTask.Companion.getLog().warning(((Object)((Object)this.app)).getClass().getSimpleName() + " has no package. Disabling annotations processing");
            }
            return map;
        }

        public InitAppTask(@NotNull GameApplication app, @NotNull DataFile dataFile) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
            Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
            this.app = app;
            this.dataFile = dataFile;
        }

        static {
            Companion = new Companion(null);
            log = FXGL.Companion.getLogger(InitAppTask.class);
        }

        @NotNull
        public static final /* synthetic */ GameApplication access$getApp$p(InitAppTask $this) {
            return $this.app;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/almasb/fxgl/app/LoadingState$InitAppTask$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getLog", "()Lcom/almasb/fxgl/core/logging/Logger;", "fxgl"})
        public static final class Companion {
            private final Logger getLog() {
                return log;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

