/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.service.Input;
import com.almasb.fxgl.service.impl.input.FXGLInput;
import com.almasb.fxgl.time.Timer;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class State {
    private Input input = new FXGLInput();
    private Timer timer = new Timer();
    private CopyOnWriteArrayList<StateListener> listeners = new CopyOnWriteArrayList();

    public final Timer getTimer() {
        return this.timer;
    }

    public final Input getInput() {
        return this.input;
    }

    public final void addStateListener(StateListener listener2) {
        this.listeners.add(listener2);
    }

    public final void removeStateListener(StateListener listener2) {
        this.listeners.remove(listener2);
    }

    protected void onEnter(State prevState) {
    }

    protected void onExit() {
    }

    protected void onUpdate(double tpf) {
    }

    void enter(State prevState) {
        this.onEnter(prevState);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onEnter(prevState);
        }
    }

    void update(double tpf) {
        this.input.onUpdate(tpf);
        this.timer.update(tpf);
        this.onUpdate(tpf);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onUpdate(tpf);
        }
    }

    void exit() {
        this.onExit();
        this.input.clearAll();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onExit();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

