/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.effect.ParticleEmitter;
import com.almasb.fxgl.entity.component.PositionComponent;
import java.util.Iterator;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;

@Required(value=PositionComponent.class)
public class ParticleControl
extends AbstractControl {
    private ParticleEmitter emitter;
    protected Array<Particle> particles = new Array(false, 256);
    private PositionComponent position;

    public ParticleControl(ParticleEmitter emitter) {
        this.emitter = emitter;
    }

    protected ParticleControl() {
    }

    public void onUpdate(Entity entity, double tpf) {
        if (this.emitter == null) {
            return;
        }
        this.particles.addAll(this.emitter.emit(this.position.getX(), this.position.getY()));
        Iterator it = this.particles.iterator();
        while (it.hasNext()) {
            Particle p = (Particle)it.next();
            if (!p.update(tpf)) continue;
            it.remove();
            FXGL.getPooler().put(p);
        }
    }

    public void onRemoved(Entity entity) {
        this.particles.clear();
    }

    public void renderParticles(GraphicsContext g, Point2D viewportOrigin) {
        for (Particle p : this.particles) {
            p.render(g, viewportOrigin);
        }
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }
}

