/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.entity.animation.EntityAnimation;
import com.almasb.fxgl.entity.component.ViewComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.ScaleTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/entity/animation/ScaleAnimation;", "Lcom/almasb/fxgl/entity/animation/EntityAnimation;", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "startScale", "Ljavafx/geometry/Point2D;", "endScale", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;Ljavafx/geometry/Point2D;Ljavafx/geometry/Point2D;)V", "getEndScale", "()Ljavafx/geometry/Point2D;", "node", "Ljavafx/scene/Node;", "getStartScale", "bindProperties", "", "buildAnimation", "Ljavafx/animation/Animation;", "unbindProperties", "fxgl"})
public final class ScaleAnimation
extends EntityAnimation {
    private Node node;
    @NotNull
    private final Point2D startScale;
    @NotNull
    private final Point2D endScale;

    @Override
    @NotNull
    public Animation buildAnimation() {
        this.node = (Node)new Rectangle();
        Duration duration = this.getAnimationBuilder().getDuration();
        Node node = this.node;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"node");
        }
        ScaleTransition anim = new ScaleTransition(duration, node);
        anim.setFromX(this.startScale.getX());
        anim.setFromY(this.startScale.getY());
        anim.setToX(this.endScale.getX());
        anim.setToY(this.endScale.getY());
        return (Animation)anim;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bindProperties() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.getAnimationBuilder().getEntities();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GameEntity gameEntity = (GameEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            ViewComponent viewComponent = it.getViewComponent();
            collection.add(viewComponent);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            ViewComponent it = (ViewComponent)((Object)element$iv);
            DoubleProperty doubleProperty = it.getView().scaleXProperty();
            Node node = this.node;
            if (node == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"node");
            }
            doubleProperty.bind((ObservableValue)node.scaleXProperty());
            DoubleProperty doubleProperty2 = it.getView().scaleYProperty();
            Node node2 = this.node;
            if (node2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"node");
            }
            doubleProperty2.bind((ObservableValue)node2.scaleYProperty());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unbindProperties() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.getAnimationBuilder().getEntities();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GameEntity gameEntity = (GameEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            ViewComponent viewComponent = it.getViewComponent();
            collection.add(viewComponent);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            ViewComponent it = (ViewComponent)((Object)element$iv);
            it.getView().scaleXProperty().unbind();
            it.getView().scaleYProperty().unbind();
        }
    }

    @NotNull
    public final Point2D getStartScale() {
        return this.startScale;
    }

    @NotNull
    public final Point2D getEndScale() {
        return this.endScale;
    }

    public ScaleAnimation(@NotNull AnimationBuilder animationBuilder, @NotNull Point2D startScale, @NotNull Point2D endScale) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        Intrinsics.checkParameterIsNotNull((Object)startScale, (String)"startScale");
        Intrinsics.checkParameterIsNotNull((Object)endScale, (String)"endScale");
        super(animationBuilder);
        this.startScale = startScale;
        this.endScale = endScale;
        this.initAnimation();
    }
}

