/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.Achievement;
import com.almasb.fxgl.gameplay.AchievementEvent;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.saving.UserProfileSavable;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0003\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/gameplay/AchievementManager;", "Lcom/almasb/fxgl/saving/UserProfileSavable;", "()V", "achievements", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/gameplay/Achievement;", "kotlin.jvm.PlatformType", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getAchievementByName", "name", "", "getAchievements", "load", "", "profile", "Lcom/almasb/fxgl/saving/UserProfile;", "registerAchievement", "a", "save", "fxgl"})
public final class AchievementManager
implements UserProfileSavable {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private final ObservableList<Achievement> achievements = FXCollections.observableArrayList();

    /*
     * WARNING - void declaration
     */
    public final void registerAchievement(@NotNull Achievement a) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Iterable iterable = $receiver$iv = (Iterable)this.achievements;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Achievement it = (Achievement)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)a.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int count = ((List)destination$iv$iv).size();
        if (count > 0) {
            throw (Throwable)new IllegalArgumentException("Achievement with name " + "\"" + a.getName() + "\"" + " exists");
        }
        a.setOnAchieved$fxgl(new Runnable(a){
            final /* synthetic */ Achievement $a;

            public final void run() {
                FXGL.Companion.getEventBus().fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
            }
            {
                this.$a = achievement;
            }
        });
        this.achievements.add((Object)a);
        this.log.debug((Supplier)new Supplier<String>(a){
            final /* synthetic */ Achievement $a;

            @NotNull
            public final String get() {
                return "Registered new achievement " + "\"" + this.$a.getName() + "\"";
            }
            {
                this.$a = achievement;
            }
        });
    }

    @NotNull
    public final Achievement getAchievementByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        for (Achievement a : this.achievements) {
            if (!Intrinsics.areEqual((Object)a.getName(), (Object)name)) continue;
            Achievement achievement = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)achievement, (String)"a");
            return achievement;
        }
        throw (Throwable)new IllegalArgumentException("Achievement with name " + "\"" + name + "\"" + " is not registered!");
    }

    public final ObservableList<Achievement> getAchievements() {
        return FXCollections.unmodifiableObservableList(this.achievements);
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("achievement");
        Iterable $receiver$iv = (Iterable)this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            bundle.put(a.getName(), (Serializable)Boolean.valueOf(a.isAchieved()));
        }
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("achievement");
        bundle.log();
        Iterable $receiver$iv = (Iterable)this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            boolean achieved = (Boolean)bundle.get(a.getName());
            if (!achieved) continue;
            a.setAchieved$fxgl();
        }
    }

    @Inject
    private AchievementManager() {
    }
}

