/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.time.LocalTimer;
import javafx.scene.image.Image;
import javafx.util.Duration;

public final class AnimatedTexture
extends Texture
implements StateListener {
    private AnimationChannel defaultChannel;
    private AnimationChannel currentChannel;
    private int currentFrame = 0;
    private double timePerAnimationFrame = 0.0;
    private LocalTimer animationTimer;
    private Runnable onAnimationEnd;

    AnimatedTexture(Image image, AnimationChannel initialChannel) {
        super(image);
        this.defaultChannel = initialChannel;
        this.animationTimer = FXGL.newLocalTimer();
        this.setAnimationChannel(initialChannel);
        FXGL.getApp().addPlayStateListener(this);
    }

    public void setAnimationChannel(AnimationChannel channel) {
        this.setAnimationChannel(channel, () -> {});
    }

    public void setAnimationChannel(AnimationChannel channel, Runnable onAnimationEnd) {
        if (this.currentChannel == channel && channel != this.defaultChannel) {
            return;
        }
        this.onAnimationEnd = onAnimationEnd;
        this.currentChannel = channel;
        this.currentFrame = 0;
        this.timePerAnimationFrame = channel.computeFrameTime();
        this.setFitWidth(channel.computeFrameWidth());
        this.setFitHeight(channel.computeFrameHeight());
        this.setViewport(channel.computeViewport(0));
        this.animationTimer.capture();
    }

    public AnimationChannel getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.animationTimer.elapsed(Duration.seconds((double)this.timePerAnimationFrame))) {
            ++this.currentFrame;
            if (this.currentFrame == this.currentChannel.frames()) {
                this.onAnimationEnd.run();
                this.setAnimationChannel(this.defaultChannel);
                return;
            }
            this.setViewport(this.currentChannel.computeViewport(this.currentFrame));
            this.animationTimer.capture();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        FXGL.getApp().removePlayStateListener(this);
    }
}

