/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import javafx.geometry.Rectangle2D;
import javafx.util.Duration;

public interface AnimationChannel {
    public Rectangle2D area();

    public int frames();

    public Duration duration();

    public String name();

    default public double computeFrameWidth() {
        return this.area().getWidth() / (double)this.frames();
    }

    default public double computeFrameHeight() {
        return this.area().getHeight();
    }

    default public double computeFrameTime() {
        return this.duration().toSeconds() / (double)this.frames();
    }

    default public Rectangle2D computeViewport(int frame) {
        double frameW = this.computeFrameWidth();
        Rectangle2D area = this.area();
        return new Rectangle2D((double)frame * frameW, area.getMinY(), frameW, area.getHeight());
    }
}

