/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.service.ExceptionHandler;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0003\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/app/FXGLExceptionHandler;", "Lcom/almasb/fxgl/service/ExceptionHandler;", "()V", "handledOnce", "", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "handle", "", "e", "", "handleFatal", "newErrorDialog", "Ljavafx/scene/control/Dialog;", "fxgl"})
public final class FXGLExceptionHandler
implements ExceptionHandler {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private boolean handledOnce;

    @Override
    public void handle(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.log.warning("Caught Exception: " + e);
        FXGL.Companion.getDisplay().showErrorBox(e);
    }

    @Override
    public void handleFatal(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.handledOnce) {
            return;
        }
        this.handledOnce = true;
        this.log.fatal("Uncaught Exception:");
        this.log.fatal(FXGLLogger.Companion.errorTraceAsString(e));
        this.log.fatal("Application will now exit");
        GameApplication app = FXGL.Companion.getApp();
        app.stopMainLoop();
        this.newErrorDialog(e).showAndWait();
        app.exit();
    }

    private final Dialog<?> newErrorDialog(Throwable e) {
        Label label = new Label("Exception stacktrace:");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        TextArea textArea = new TextArea(sw.toString());
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setPrefSize(600.0, 600.0);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)((Node)textArea), (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)((Node)textArea), (Priority)Priority.ALWAYS);
        GridPane root = new GridPane();
        root.setVisible(false);
        root.setMaxWidth(Double.MAX_VALUE);
        root.add((Node)label, 0, 0);
        root.add((Node)textArea, 0, 1);
        Dialog dialog2 = new Dialog();
        dialog2.setTitle("Uncaught Exception");
        dialog2.initModality(Modality.APPLICATION_MODAL);
        DialogPane dialogPane = dialog2.getDialogPane();
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        dialogPane.setContentText(e.toString());
        dialogPane.setExpandableContent((Node)root);
        return dialog2;
    }

    @Inject
    private FXGLExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public final void uncaughtException(Thread $noName_0, Throwable e) {
                Throwable throwable = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e");
                this.handleFatal(throwable);
            }
        });
    }
}

