/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.logging;

import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Log4j2;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.logging.SystemLogger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/almasb/fxgl/core/logging/FXGLLogger;", "", "()V", "Companion", "fxgl"})
public final class FXGLLogger {
    private static final int MAX_LOGS = 10;
    public static final Companion Companion = new Companion(null);

    private FXGLLogger() {
    }

    static {
        MAX_LOGS = 10;
    }

    @JvmStatic
    public static final void configure(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Companion.configure(fileName);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Companion.get(name);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull Class<?> caller) {
        Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
        return Companion.get(caller);
    }

    @JvmStatic
    @NotNull
    public static final Logger getSystemLogger() {
        return Companion.getSystemLogger();
    }

    @JvmStatic
    @NotNull
    public static final String errorTraceAsString(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return Companion.errorTraceAsString(e);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\b\u0010\u0015\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/core/logging/FXGLLogger$Companion;", "", "()V", "MAX_LOGS", "", "getMAX_LOGS", "()I", "cleanOldLogs", "", "configure", "fileName", "", "errorTraceAsString", "e", "", "get", "Lcom/almasb/fxgl/core/logging/Logger;", "caller", "Ljava/lang/Class;", "name", "getSystemLogger", "logSystemInfo", "fxgl"})
    public static final class Companion {
        private final int getMAX_LOGS() {
            return MAX_LOGS;
        }

        @JvmStatic
        public final void configure(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.cleanOldLogs();
            Configurator.initialize((String)"FXGL", (String)fileName);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Log4j2(name);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull Class<?> caller) {
            Intrinsics.checkParameterIsNotNull(caller, (String)"caller");
            String string = caller.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"caller.simpleName");
            return this.get(string);
        }

        @JvmStatic
        @NotNull
        public final Logger getSystemLogger() {
            return SystemLogger.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final String errorTraceAsString(@NotNull Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            StringBuilder sb = new StringBuilder();
            sb.append("\n\nException occurred: ").append(e.getClass().getCanonicalName()).append(" : ").append(e.getMessage() + "\n");
            StackTraceElement[] elements = e.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement el = elements[i];
                sb.append("E: ").append(el.toString()).append('\n');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void cleanOldLogs() {
            int n;
            int n2;
            List logs2;
            int logSize;
            Path logDir = Paths.get("logs/", new String[0]);
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectory(logDir, new FileAttribute[0]);
                Path readmeFile = Paths.get("logs/Readme.txt", new String[0]);
                Files.write(readmeFile, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)"This directory contains FXGL log files."), new OpenOption[0]);
            }
            if ((logSize = (logs2 = Files.walk(logDir, 1, new FileVisitOption[0]).filter(cleanOldLogs.logs.1.INSTANCE).sorted(cleanOldLogs.logs.2.INSTANCE).collect(Collectors.toList())).size()) >= this.getMAX_LOGS() && (n2 = 0) <= (n = logSize + 1 - this.getMAX_LOGS() - 1)) {
                while (true) {
                    void i;
                    Files.delete((Path)logs2.get((int)i));
                    if (i == n) break;
                    ++i;
                }
            }
        }

        private final void logSystemInfo() {
            Logger logger = this.get("FXGLLogger");
            logger.debug("Logging System Info");
            Runtime rt = Runtime.getRuntime();
            double MB = 0x100000;
            logger.debug("CPU cores: " + rt.availableProcessors());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Free Memory: %.0fMB";
            Object[] objectArray = new Object[]{(double)rt.freeMemory() / MB};
            Logger logger2 = logger;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            logger2.debug(string3);
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "Max Memory: %.0fMB";
            objectArray = new Object[]{(double)rt.maxMemory() / MB};
            logger2 = logger;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string3 = string4;
            logger2.debug(string3);
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "Total Memory: %.0fMB";
            objectArray = new Object[]{(double)rt.totalMemory() / MB};
            logger2 = logger;
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
            string3 = string5;
            logger2.debug(string3);
            logger.debug("System Properties:");
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)new BiConsumer<Object, Object>(logger){
                final /* synthetic */ Logger $logger;

                public final void accept(Object k, Object v) {
                    this.$logger.debug(new Supplier<String>(k, v){
                        final /* synthetic */ Object $k;
                        final /* synthetic */ Object $v;

                        @NotNull
                        public final String get() {
                            return this.$k + "=" + this.$v;
                        }
                        {
                            this.$k = object;
                            this.$v = object2;
                        }
                    });
                }
                {
                    this.$logger = logger;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

