/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.BezierSpline;
import com.almasb.fxgl.core.math.Vec2;

class ClosedBezierSplineFactory {
    ClosedBezierSplineFactory() {
    }

    public static BezierSpline newBezierSpline(Vec2[] knots) {
        int n = knots.length;
        double[] a = new double[n];
        double[] b = new double[n];
        double[] c = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = 1.0;
            b[i] = 4.0;
            c[i] = 1.0;
        }
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            int j = i == n - 1 ? 0 : i + 1;
            rhs[i] = 4.0f * knots[i].x + 2.0f * knots[j].x;
        }
        double[] x = Cyclic.solve(a, b, c, 1.0, 1.0, rhs);
        for (int i = 0; i < n; ++i) {
            int j = i == n - 1 ? 0 : i + 1;
            rhs[i] = 4.0f * knots[i].y + 2.0f * knots[j].y;
        }
        double[] y = Cyclic.solve(a, b, c, 1.0, 1.0, rhs);
        BezierSpline spline = new BezierSpline();
        for (int i = 0; i < n; ++i) {
            int j = i + 1 < n ? i + 1 : 0;
            spline.addCurve(new BezierSpline.BezierCurve(knots[i], knots[j], new Vec2(x[i], y[i]), new Vec2((double)(2.0f * knots[j].x) - x[j], (double)(2.0f * knots[j].y) - y[j])));
        }
        return spline;
    }

    private static class Tridiagonal {
        private Tridiagonal() {
        }

        public static double[] solve(double[] a, double[] b, double[] c, double[] rhs) {
            int j;
            if (a.length != b.length || c.length != b.length || rhs.length != b.length) {
                throw new IllegalArgumentException("Diagonal and rhs vectors must have the same size.");
            }
            if (b[0] == 0.0) {
                throw new IllegalArgumentException("Singular matrix.");
            }
            int n = rhs.length;
            double[] u = new double[n];
            double[] gam = new double[n];
            double bet = b[0];
            u[0] = rhs[0] / bet;
            for (j = 1; j < n; ++j) {
                gam[j] = c[j - 1] / bet;
                bet = b[j] - a[j] * gam[j];
                if (bet == 0.0) {
                    throw new RuntimeException("Singular matrix.");
                }
                u[j] = (rhs[j] - a[j] * u[j - 1]) / bet;
            }
            for (j = 1; j < n; ++j) {
                int n2 = n - j - 1;
                u[n2] = u[n2] - gam[n - j] * u[n - j];
            }
            return u;
        }
    }

    private static class Cyclic {
        private Cyclic() {
        }

        public static double[] solve(double[] a, double[] b, double[] c, double alpha, double beta, double[] rhs) {
            if (a.length != b.length || c.length != b.length || rhs.length != b.length) {
                throw new IllegalArgumentException("Diagonal and rhs vectors must have the same size.");
            }
            int n = b.length;
            if (n <= 2) {
                throw new IllegalArgumentException("n too small in Cyclic; must be greater than 2.");
            }
            double gamma = -b[0];
            double[] bb = new double[n];
            bb[0] = b[0] - gamma;
            bb[n - 1] = b[n - 1] - alpha * beta / gamma;
            for (int i = 1; i < n - 1; ++i) {
                bb[i] = b[i];
            }
            double[] solution = Tridiagonal.solve(a, bb, c, rhs);
            double[] x = new double[n];
            for (int k = 0; k < n; ++k) {
                x[k] = solution[k];
            }
            double[] u = new double[n];
            u[0] = gamma;
            u[n - 1] = alpha;
            for (int i = 1; i < n - 1; ++i) {
                u[i] = 0.0;
            }
            solution = Tridiagonal.solve(a, bb, c, u);
            double[] z = new double[n];
            for (int k = 0; k < n; ++k) {
                z[k] = solution[k];
            }
            double fact = (x[0] + beta * x[n - 1] / gamma) / (1.0 + z[0] + beta * z[n - 1] / gamma);
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                x[n2] = x[n2] - fact * z[i];
            }
            return x;
        }
    }
}

