/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

public final class Quaternion {
    private final double x;
    private final double y;
    private final double z;
    private final double w;

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public Quaternion normalize() {
        double length = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        return new Quaternion(this.x / length, this.y / length, this.z / length, this.w / length);
    }

    public Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public Quaternion multiply(Quaternion other) {
        double _x = this.x * other.w + this.w * other.x + this.y * other.z - this.z * other.y;
        double _y = this.y * other.w + this.w * other.y + this.z * other.x - this.x * other.z;
        double _z = this.z * other.w + this.w * other.z + this.x * other.y - this.y * other.x;
        double _w = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        return new Quaternion(_x, _y, _z, _w);
    }
}

