/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ecs;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.ecs.AbstractComponent;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.ComponentListener;
import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.ControlListener;
import com.almasb.fxgl.ecs.EntityCopier;
import com.almasb.fxgl.ecs.EntitySerializer;
import com.almasb.fxgl.ecs.EntityWorld;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.io.serialization.Bundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;

public class Entity {
    private static final Logger log = FXGLLogger.get(Entity.class);
    private final ObjectMap<String, Object> properties = new ObjectMap();
    ObjectMap<Class<? extends Control>, Control> controls = new ObjectMap();
    ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private List<ControlListener> controlListeners = new ArrayList<ControlListener>();
    private List<ComponentListener> componentListeners = new ArrayList<ComponentListener>();
    private boolean controlsEnabled = true;
    private Runnable onActive = null;
    private Runnable onNotActive = null;
    private EntityWorld world;
    private boolean updating = false;
    private boolean delayedRemove = false;
    private boolean cleaning = false;

    public final void setProperty(String key, Object value) {
        this.checkValid();
        this.properties.put(key, value);
    }

    public final <T> T getProperty(String key) {
        this.checkValid();
        T value = this.properties.get(key, null);
        if (value == null) {
            throw new IllegalArgumentException("No property with key: " + key);
        }
        return value;
    }

    public final boolean hasControl(Class<? extends Control> type) {
        this.checkValid();
        return this.controls.containsKey(type);
    }

    public final <T extends Control> Optional<T> getControl(Class<T> type) {
        this.checkValid();
        return Optional.ofNullable(this.getControlUnsafe(type));
    }

    public final <T extends Control> T getControlUnsafe(Class<T> type) {
        this.checkValid();
        return (T)((Control)type.cast(this.controls.get(type)));
    }

    public final Array<Control> getControls() {
        this.checkValid();
        return this.controls.values().toArray();
    }

    public final void addControl(Control control) {
        this.checkValid();
        Class<?> type = control.getClass();
        if (type.getCanonicalName() == null) {
            log.fatal("Adding anonymous control: " + type.getName());
            throw new IllegalArgumentException("Anonymous controls are not allowed! - " + type.getName());
        }
        if (this.hasControl(type)) {
            log.fatal("Entity already has a control with type: " + type.getCanonicalName());
            throw new IllegalArgumentException("Entity already has a control with type: " + type.getCanonicalName());
        }
        this.checkRequirementsMet(control.getClass());
        this.controls.put(control.getClass(), control);
        if (control instanceof AbstractControl) {
            ((AbstractControl)control).setEntity(this);
        }
        this.injectFields(control);
        control.onAdded(this);
        this.notifyControlAdded(control);
    }

    private void injectFields(Control control) {
        ReflectionUtils.findFieldsByType(control, Component.class).forEach(field -> {
            Object comp = this.getComponentUnsafe(field.getType());
            if (comp != null) {
                ReflectionUtils.inject(field, control, comp);
            } else {
                log.warning("Injection failed, entity has no component: " + field.getType());
            }
        });
        ReflectionUtils.findFieldsByType(control, Control.class).forEach(field -> {
            Object ctrl = this.getControlUnsafe(field.getType());
            if (ctrl != null) {
                ReflectionUtils.inject(field, control, ctrl);
            } else {
                log.warning("Injection failed, entity has no control: " + field.getType());
            }
        });
    }

    public final void removeControl(Class<? extends Control> type) {
        this.checkValid();
        Control control = this.getControlUnsafe(type);
        if (control == null) {
            log.warning("Cannot remove control " + type.getSimpleName() + ". Entity does not have one");
        } else {
            this.controls.remove(control.getClass());
            this.removeControlImpl(control);
        }
    }

    public final void removeAllControls() {
        this.checkValid();
        for (Control control : this.controls.values()) {
            this.removeControlImpl(control);
        }
        this.controls.clear();
    }

    private void removeControlImpl(Control control) {
        this.notifyControlRemoved(control);
        control.onRemoved(this);
        if (control instanceof AbstractControl) {
            ((AbstractControl)control).setEntity(null);
        }
    }

    public void addControlListener(ControlListener listener2) {
        this.checkValid();
        this.controlListeners.add(listener2);
    }

    public void removeControlListener(ControlListener listener2) {
        this.checkValid();
        this.controlListeners.remove(listener2);
    }

    private void notifyControlAdded(Control control) {
        for (int i = 0; i < this.controlListeners.size(); ++i) {
            this.controlListeners.get(i).onControlAdded(control);
        }
    }

    private void notifyControlRemoved(Control control) {
        for (int i = 0; i < this.controlListeners.size(); ++i) {
            this.controlListeners.get(i).onControlRemoved(control);
        }
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        this.checkValid();
        return this.components.containsKey(type);
    }

    public final <T extends Component> Optional<T> getComponent(Class<T> type) {
        this.checkValid();
        return Optional.ofNullable(this.getComponentUnsafe(type));
    }

    public final <T extends Component> T getComponentUnsafe(Class<T> type) {
        this.checkValid();
        return (T)((Component)type.cast(this.components.get(type)));
    }

    public final Array<Component> getComponents() {
        this.checkValid();
        return this.components.values().toArray();
    }

    public final void addComponent(Component component) {
        this.checkValid();
        Class<?> type = component.getClass();
        if (type.getCanonicalName() == null) {
            throw new IllegalArgumentException("Anonymous components are not allowed! - " + type.getName());
        }
        if (this.hasComponent(type)) {
            throw new IllegalArgumentException("Entity already has a component with type: " + type.getCanonicalName());
        }
        if (component instanceof AbstractComponent) {
            AbstractComponent c = (AbstractComponent)component;
            c.setEntity(this);
        }
        this.checkRequirementsMet(component.getClass());
        this.components.put(component.getClass(), component);
        component.onAdded(this);
        if (this.isActive()) {
            this.world.onComponentAdded(component, this);
        }
        this.notifyComponentAdded(component);
    }

    public final void removeComponent(Class<? extends Component> type) {
        this.checkValid();
        Component component = this.getComponentUnsafe(type);
        if (component == null) {
            log.warning("Attempted to remove component but entity doesn't have a component with type: " + type.getSimpleName());
        } else {
            if (!this.cleaning) {
                this.checkNotRequiredByAny(type);
            }
            this.components.remove(component.getClass());
            if (this.isActive()) {
                this.world.onComponentRemoved(component, this);
            }
            this.removeComponentImpl(component);
        }
    }

    public final void removeAllComponents() {
        this.checkValid();
        for (Component component : this.components.values()) {
            this.removeComponentImpl(component);
        }
        this.components.clear();
    }

    private void removeComponentImpl(Component component) {
        this.notifyComponentRemoved(component);
        component.onRemoved(this);
        if (component instanceof AbstractComponent) {
            AbstractComponent c = (AbstractComponent)component;
            c.setEntity(null);
        }
    }

    public void addComponentListener(ComponentListener listener2) {
        this.componentListeners.add(listener2);
    }

    public void removeComponentListener(ComponentListener listener2) {
        this.componentListeners.remove(listener2);
    }

    private void notifyComponentAdded(Component component) {
        for (int i = 0; i < this.componentListeners.size(); ++i) {
            this.componentListeners.get(i).onComponentAdded(component);
        }
    }

    private void notifyComponentRemoved(Component component) {
        for (int i = 0; i < this.componentListeners.size(); ++i) {
            this.componentListeners.get(i).onComponentRemoved(component);
        }
    }

    private void checkRequirementsMet(Class<?> type) {
        Required[] required;
        for (Required r : required = (Required[])type.getAnnotationsByType(Required.class)) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class clazz : this.components.keys()) {
            for (Required required : (Required[])clazz.getAnnotationsByType(Required.class)) {
                if (!required.value().equals(type)) continue;
                throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + clazz.getSimpleName());
            }
        }
        for (Class clazz : this.controls.keys()) {
            for (Required required : (Required[])clazz.getAnnotationsByType(Required.class)) {
                if (!required.value().equals(type)) continue;
                throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + clazz.getSimpleName());
            }
        }
    }

    public final void setControlsEnabled(boolean b) {
        this.controlsEnabled = b;
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setOnActive(Runnable action2) {
        if (this.isActive()) {
            action2.run();
            return;
        }
        this.onActive = action2;
    }

    public final void setOnNotActive(Runnable action2) {
        if (!this.isActive()) {
            action2.run();
            return;
        }
        this.onNotActive = action2;
    }

    public EntityWorld getWorld() {
        return this.world;
    }

    void init(EntityWorld world) {
        this.world = world;
        if (this.onActive != null) {
            this.onActive.run();
        }
        this.active.set(true);
    }

    void update(double tpf) {
        this.updating = true;
        if (this.controlsEnabled) {
            for (Control c : this.controls.values()) {
                if (c.isPaused()) continue;
                c.onUpdate(this, tpf);
            }
        }
        this.updating = false;
        if (this.delayedRemove) {
            this.removeFromWorld();
        }
    }

    void clean() {
        this.cleaning = true;
        if (this.onNotActive != null) {
            this.onNotActive.run();
        }
        this.active.set(false);
        this.removeAllControls();
        this.removeAllComponents();
        this.controlListeners.clear();
        this.componentListeners.clear();
        this.properties.clear();
        this.controlsEnabled = true;
        this.world = null;
        this.onActive = null;
        this.onNotActive = null;
    }

    private void checkValid() {
        if (this.cleaning && this.world == null) {
            throw new IllegalStateException("Attempted access a cleaned entity!");
        }
    }

    public final void removeFromWorld() {
        this.checkValid();
        if (this.updating) {
            this.delayedRemove = true;
        } else {
            this.world.removeEntity(this);
        }
    }

    public Entity copy() {
        this.checkValid();
        return EntityCopier.INSTANCE.copy(this);
    }

    public void save(Bundle bundle) {
        this.checkValid();
        EntitySerializer.INSTANCE.save(this, bundle);
    }

    public void load(Bundle bundle) {
        this.checkValid();
        EntitySerializer.INSTANCE.load(this, bundle);
    }

    public String toString() {
        return "Entity(" + String.join((CharSequence)"\n", "components=" + this.components.values(), "controls=" + this.controls.values()) + ")";
    }
}

