/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ecs;

import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.serialization.SerializableComponent;
import com.almasb.fxgl.ecs.serialization.SerializableControl;
import com.almasb.fxgl.io.serialization.Bundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/ecs/EntitySerializer;", "", "()V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "load", "", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "bundle", "Lcom/almasb/fxgl/io/serialization/Bundle;", "save", "fxgl"})
public final class EntitySerializer {
    private static final Logger log;
    public static final EntitySerializer INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void save(@NotNull Entity entity, @NotNull Bundle bundle) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object element$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Bundle componentsBundle = new Bundle("components");
        Iterable iterable = entity.components.values();
        void var5_5 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof SerializableComponent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv2) {
            SerializableComponent it = (SerializableComponent)element$iv2;
            String string = it.getClass().getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.javaClass.canonicalName");
            Bundle b = new Bundle(string);
            it.write(b);
            componentsBundle.put(b.getName(), b);
        }
        Bundle controlsBundle = new Bundle("controls");
        $receiver$iv$iv2 = entity.controls.values();
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof SerializableControl)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        for (Object element$iv3 : $receiver$iv) {
            SerializableControl it = (SerializableControl)element$iv3;
            String string = it.getClass().getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.javaClass.canonicalName");
            Bundle b = new Bundle(string);
            it.write(b);
            controlsBundle.put(b.getName(), b);
        }
        bundle.put("components", componentsBundle);
        bundle.put("controls", controlsBundle);
    }

    public final void load(@NotNull Entity entity, @NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Bundle componentsBundle = (Bundle)bundle.get("components");
        for (Component component : entity.components.values()) {
            if (!(component instanceof SerializableComponent)) continue;
            String string = component.getClass().getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.javaClass.canonicalName");
            Bundle b = (Bundle)componentsBundle.get(string);
            if (b != null) {
                ((SerializableComponent)((Object)component)).read(b);
                continue;
            }
            log.warning("Bundle " + componentsBundle + " does not have SerializableComponent: " + component);
        }
        Bundle controlsBundle = (Bundle)bundle.get("controls");
        for (Control control : entity.controls.values()) {
            if (!(control instanceof SerializableControl)) continue;
            String string = control.getClass().getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"control.javaClass.canonicalName");
            Bundle b = (Bundle)controlsBundle.get(string);
            if (b != null) {
                ((SerializableControl)((Object)control)).read(b);
                continue;
            }
            log.warning("Bundle " + componentsBundle + " does not have SerializableControl: " + control);
        }
    }

    private EntitySerializer() {
        INSTANCE = this;
        log = FXGLLogger.Companion.get(this.getClass());
    }

    static {
        new EntitySerializer();
    }
}

