/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ecs;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.EntityWorldListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EntityWorld {
    private static final Logger log = FXGLLogger.get(EntityWorld.class);
    private Array<Entity> updateList;
    private Array<Entity> waitingList;
    protected List<Entity> entities;
    private Array<EntityWorldListener> worldListeners = new Array(true, 16);
    private ObjectMap<Class<? extends Component>, Array<Entity>> componentMap = new ObjectMap();

    public EntityWorld() {
        this(32);
    }

    public EntityWorld(int initialCapacity) {
        this.updateList = new Array(true, initialCapacity);
        this.waitingList = new Array(false, initialCapacity);
        this.entities = new ArrayList<Entity>(initialCapacity);
    }

    public final void addEntity(Entity entity) {
        if (entity.isActive()) {
            throw new IllegalArgumentException("Entity is already attached to world");
        }
        this.waitingList.add(entity);
        this.entities.add(entity);
        for (Class clazz : entity.components.keys()) {
            this.addComponentMap(clazz, entity);
        }
        entity.init(this);
        this.notifyEntityAdded(entity);
    }

    public final void addEntities(Entity ... entitiesToAdd) {
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    public final void removeEntity(Entity entity) {
        if (entity.getWorld() != this) {
            throw new IllegalArgumentException("Attempted to remove entity not attached to this world");
        }
        this.entities.remove(entity);
        for (Class clazz : entity.components.keys()) {
            this.removeComponentMap(clazz, entity);
        }
        this.notifyEntityRemoved(entity);
        entity.clean();
    }

    public final void removeEntities(Entity ... entitiesToRemove) {
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    protected void update(double tpf) {
        this.updateList.addAll(this.waitingList);
        this.waitingList.clear();
        Iterator<Entity> it = this.updateList.iterator();
        while (it.hasNext()) {
            Entity e = it.next();
            if (e.isActive()) {
                e.update(tpf);
                continue;
            }
            it.remove();
        }
        this.notifyWorldUpdated(tpf);
    }

    protected void reset() {
        log.debug("Resetting entity world");
        for (Entity e : this.updateList) {
            if (!e.isActive()) continue;
            this.notifyEntityRemoved(e);
            e.clean();
        }
        for (Entity e : this.waitingList) {
            this.notifyEntityRemoved(e);
            e.clean();
        }
        this.waitingList.clear();
        this.updateList.clear();
        this.entities.clear();
        this.componentMap.clear();
        this.notifyWorldReset();
    }

    public final void addWorldListener(EntityWorldListener listener2) {
        this.worldListeners.add(listener2);
    }

    public final void removeWorldListener(EntityWorldListener listener2) {
        this.worldListeners.removeValue(listener2, true);
    }

    private void notifyEntityAdded(Entity e) {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onEntityAdded(e);
        }
    }

    private void notifyEntityRemoved(Entity e) {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onEntityRemoved(e);
        }
    }

    private void notifyWorldUpdated(double tpf) {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onWorldUpdate(tpf);
        }
    }

    private void notifyWorldReset() {
        for (int i = 0; i < this.worldListeners.size(); ++i) {
            this.worldListeners.get(i).onWorldReset();
        }
    }

    private void addComponentMap(Class<? extends Component> type, Entity e) {
        Array<Entity> array = this.componentMap.get(type);
        if (array == null) {
            array = new Array(false, 128);
            this.componentMap.put(type, array);
        }
        array.add(e);
    }

    private void removeComponentMap(Class<? extends Component> type, Entity e) {
        Array<Entity> array = this.componentMap.get(type);
        array.removeValue(e, true);
    }

    public final List<Entity> getEntities() {
        return this.entities;
    }

    public final List<Entity> getEntitiesCopy() {
        return new ArrayList<Entity>(this.entities);
    }

    public final Array<Entity> getEntitiesByComponent(Class<? extends Component> type) {
        return this.componentMap.get(type, Array.empty());
    }

    void onComponentAdded(Component component, Entity e) {
        this.addComponentMap(component.getClass(), e);
    }

    void onComponentRemoved(Component component, Entity e) {
        this.removeComponentMap(component.getClass(), e);
    }
}

