/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Poolable;
import com.almasb.fxgl.effect.ParticleEmitter;
import java.util.function.Consumer;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class Particle
implements Poolable {
    private Vec2 position = new Vec2();
    private Vec2 velocity = new Vec2();
    private Vec2 gravity = new Vec2();
    private Vec2 radius = new Vec2();
    private Vec2 scale = new Vec2();
    private double initialLife;
    private double life;
    private Paint startColor;
    private Paint endColor;
    private BlendMode blendMode;
    private Image image = null;
    private Consumer<Particle> control = null;

    public Particle(Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode) {
        this(null, position2, vel, gravity, radius, scale, expireTime, startColor, endColor, blendMode);
    }

    public Particle(Image image, Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode) {
        this.init(image, position2, vel, gravity, radius, scale, expireTime, startColor, endColor, blendMode);
    }

    public Particle() {
        this.reset();
    }

    public final void init(Image image, Point2D position2, Point2D vel, Point2D gravity, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode) {
        this.image = image;
        this.position.set(position2);
        this.radius.set((float)radius, (float)radius);
        this.scale.set(scale);
        this.velocity.set(vel);
        this.gravity.set(gravity);
        this.startColor = startColor;
        this.endColor = endColor;
        this.blendMode = blendMode;
        this.life = this.initialLife = expireTime.toSeconds();
    }

    @Override
    public void reset() {
        this.image = null;
        this.position.setZero();
        this.velocity.setZero();
        this.gravity.setZero();
        this.radius.setZero();
        this.scale.setZero();
        this.startColor = Color.TRANSPARENT;
        this.endColor = Color.TRANSPARENT;
        this.blendMode = BlendMode.SRC_OVER;
        this.initialLife = 0.0;
        this.life = 0.0;
        this.control = null;
    }

    public void setControl(Consumer<Particle> control) {
        this.control = control;
    }

    boolean update(double tpf) {
        this.position.addLocal(this.velocity);
        this.velocity.addLocal(this.gravity);
        this.radius.addLocal(this.scale);
        this.life -= tpf;
        if (this.control != null) {
            this.control.accept(this);
        }
        return this.life <= 0.0 || this.radius.x <= 0.0f || this.radius.y <= 0.0f;
    }

    void render(GraphicsContext g, Point2D viewportOrigin) {
        double alpha = this.life / this.initialLife;
        g.setGlobalAlpha(alpha);
        g.setGlobalBlendMode(this.blendMode);
        Image particleImage = this.image != null ? this.image : ParticleEmitter.getCachedImage((Color)this.startColor, (Color)this.endColor, (int)(alpha * 99.0));
        g.save();
        g.translate((double)this.position.x - viewportOrigin.getX(), (double)this.position.y - viewportOrigin.getY());
        g.scale((double)(this.radius.x * 2.0f) / particleImage.getWidth(), (double)(this.radius.y * 2.0f) / particleImage.getHeight());
        g.drawImage(particleImage, 0.0, 0.0);
        g.restore();
    }
}

