/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.util.TriFunction;
import java.util.Random;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ParticleEmitter {
    private static final ObjectMap<Color, ObjectMap<Color, Image[]>> IMAGE_CACHE;
    private Random random = FXGLMath.getRandom();
    private int numParticles = 25;
    private double emissionRate = 1.0;
    private double sizeMin = 9.0;
    private double sizeMax = 12.0;
    private Paint startColor = Color.TRANSPARENT;
    private Paint endColor = Color.TRANSPARENT;
    private Supplier<Point2D> gravityFunction = () -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> velocityFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> spawnPointFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> scaleFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Duration> expireFunction = (i, x, y) -> Duration.seconds((double)1.0);
    private BlendMode blendMode = BlendMode.SRC_OVER;
    private Image sourceImage = null;
    private double rateAC = 1.0;
    private Array<Particle> emissionParticles = new Array(false, this.numParticles);

    private static Image createImage(Node node) {
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        int imageWidth = (int)node.getBoundsInLocal().getWidth();
        int imageHeight = (int)node.getBoundsInLocal().getHeight();
        WritableImage image = new WritableImage(imageWidth, imageHeight);
        Async.startFX(() -> node.snapshot(parameters, image)).await();
        return image;
    }

    private static Image[] preCreateImages(Color startColor, Color endColor) {
        int count = 100;
        double width = count;
        Stop[] stops = new Stop[]{new Stop(0.0, Color.BLACK.deriveColor(1.0, 1.0, 1.0, 0.0)), new Stop(0.3, endColor), new Stop(0.9, startColor), new Stop(1.0, startColor)};
        Rectangle rectangle = new Rectangle(width, 1.0, (Paint)new LinearGradient(0.0, 0.0, width, 0.0, false, CycleMethod.NO_CYCLE, stops));
        Image lookupImage = ParticleEmitter.createImage((Node)rectangle);
        Image[] list = new Image[count];
        double radius = 10.0;
        for (int i = 0; i < count; ++i) {
            Color color = lookupImage.getPixelReader().getColor(i, 0);
            Circle ball = new Circle(radius);
            RadialGradient gradient1 = new RadialGradient(0.0, 0.0, 0.0, 0.0, radius, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, color.deriveColor(1.0, 1.0, 1.0, 1.0)), new Stop(1.0, color.deriveColor(1.0, 1.0, 1.0, 0.0))});
            ball.setFill((Paint)gradient1);
            list[i] = ParticleEmitter.createImage((Node)ball);
        }
        return list;
    }

    static Image getCachedImage(Color startColor, Color endColor, int index) {
        Image[] images;
        ObjectMap<Object, Object> map = IMAGE_CACHE.get(startColor);
        if (map == null) {
            map = new ObjectMap();
            IMAGE_CACHE.put(startColor, map);
        }
        if ((images = map.get(endColor)) == null) {
            images = ParticleEmitter.preCreateImages(startColor, endColor);
            map.put(endColor, images);
        }
        return images[index];
    }

    public final double getSizeMin() {
        return this.sizeMin;
    }

    public final double getSizeMax() {
        return this.sizeMax;
    }

    protected final double getRandomSize() {
        return this.rand(this.getSizeMin(), this.getSizeMax());
    }

    public final void setSize(double min, double max) {
        this.sizeMin = min;
        this.sizeMax = max;
    }

    public Paint getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Paint startColor) {
        this.startColor = startColor;
    }

    public Paint getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Paint endColor) {
        this.endColor = endColor;
    }

    public Paint getColor() {
        return this.startColor;
    }

    public void setColor(Paint startColor) {
        this.startColor = startColor;
        this.endColor = startColor;
    }

    public final Supplier<Point2D> getGravityFunction() {
        return this.gravityFunction;
    }

    public final void setGravityFunction(Supplier<Point2D> gravityFunction) {
        this.gravityFunction = gravityFunction;
    }

    public final void setVelocityFunction(TriFunction<Integer, Double, Double, Point2D> velocityFunction) {
        this.velocityFunction = velocityFunction;
    }

    public final void setSpawnPointFunction(TriFunction<Integer, Double, Double, Point2D> spawnPointFunction) {
        this.spawnPointFunction = spawnPointFunction;
    }

    public final void setScaleFunction(TriFunction<Integer, Double, Double, Point2D> scaleFunction) {
        this.scaleFunction = scaleFunction;
    }

    public final void setExpireFunction(TriFunction<Integer, Double, Double, Duration> expireFunction) {
        this.expireFunction = expireFunction;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public void setSourceImage(Image sourceImage) {
        this.sourceImage = sourceImage;
    }

    public final int getNumParticles() {
        return this.numParticles;
    }

    public final void setNumParticles(int numParticles) {
        this.numParticles = numParticles;
    }

    public final void setEmissionRate(double emissionRate) {
        this.emissionRate = emissionRate;
    }

    protected final double rand() {
        return this.random.nextDouble();
    }

    protected final double rand(double min, double max) {
        return this.rand() * (max - min) + min;
    }

    final Array<Particle> emit(double x, double y) {
        this.rateAC += this.emissionRate;
        if (this.rateAC < 1.0 || this.emissionRate == 0.0) {
            return Array.empty();
        }
        this.rateAC = 0.0;
        this.emissionParticles.clear();
        for (int i = 0; i < this.numParticles; ++i) {
            this.emissionParticles.add(this.emit(i, x, y));
        }
        return this.emissionParticles;
    }

    private Particle emit(int i, double x, double y) {
        Particle particle = FXGL.getPooler().get(Particle.class);
        particle.init(this.sourceImage, this.spawnPointFunction.apply(i, x, y), this.velocityFunction.apply(i, x, y), this.gravityFunction.get(), this.getRandomSize(), this.scaleFunction.apply(i, x, y), this.expireFunction.apply(i, x, y), this.getStartColor(), this.getEndColor(), this.blendMode);
        return particle;
    }

    static {
        FXGL.getPooler().registerPool(Particle.class, new Pool<Particle>(256){

            @Override
            protected Particle newObject() {
                return new Particle();
            }
        });
        IMAGE_CACHE = new ObjectMap();
    }
}

