/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.annotation.Spawns;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.EntityWorld;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.GameWorldQuery;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.IDComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.event.EventTrigger;
import com.almasb.fxgl.gameplay.Level;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.TiledObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

@Singleton
public final class GameWorld
extends EntityWorld {
    private static final Logger log = FXGL.getLogger("FXGL.GameWorld");
    private Array<EventTrigger<?>> eventTriggers = new Array(false, 32);
    private ObjectProperty<Entity> selectedEntity = new SimpleObjectProperty();
    private EntityFactory entityFactory = null;
    private ObjectMap<String, EntitySpawner> entitySpawners = new ObjectMap();
    private GameWorldQuery query = new GameWorldQuery(this.entities);

    @Inject
    protected GameWorld() {
        log.debug("Game world initialized");
    }

    public void onUpdate(double tpf) {
        this.update(tpf);
        this.updateTriggers(tpf);
    }

    private void updateTriggers(double tpf) {
        Iterator<EventTrigger<?>> it = this.eventTriggers.iterator();
        while (it.hasNext()) {
            EventTrigger<?> trigger = it.next();
            trigger.onUpdate(tpf);
            if (!trigger.reachedLimit()) continue;
            it.remove();
        }
    }

    @Override
    public void reset() {
        log.debug("Resetting game world");
        super.reset();
    }

    public void addEventTrigger(EventTrigger<?> trigger) {
        this.eventTriggers.add(trigger);
    }

    public void removeEventTrigger(EventTrigger<?> trigger) {
        this.eventTriggers.removeValue(trigger, true);
    }

    public Optional<Entity> getSelectedEntity() {
        return Optional.ofNullable(this.selectedEntity.get());
    }

    public ObjectProperty<Entity> selectedEntityProperty() {
        return this.selectedEntity;
    }

    public void setLevel(Level level) {
        this.reset();
        log.debug("Setting level: " + level);
        level.getEntities().forEach(this::addEntity);
    }

    public void setLevelFromMap(TiledMap map) {
        this.reset();
        log.debug("Setting level from map");
        map.getLayers().stream().filter(l -> l.getType().equals("tilelayer")).forEach(l -> Entities.builder().viewFromTiles(map, l.getName(), RenderLayer.BACKGROUND).buildAndAttach(this));
        map.getLayers().stream().filter(l -> l.getType().equals("objectgroup")).forEach(l -> l.getObjects().forEach(obj -> this.spawn(obj.getName(), new SpawnData((TiledObject)obj))));
    }

    public <T extends EntityFactory> T getEntityFactory() {
        return (T)this.entityFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
        this.entitySpawners.clear();
        ReflectionUtils.findMethodsMapToFunctions(entityFactory, Spawns.class, EntitySpawner.class).forEach((annotation, entitySpawner) -> this.entitySpawners.put(annotation.value(), (EntitySpawner)entitySpawner));
    }

    public Entity spawn(String entityName) {
        return this.spawn(entityName, 0.0, 0.0);
    }

    public Entity spawn(String entityName, Point2D position2) {
        return this.spawn(entityName, position2.getX(), position2.getY());
    }

    public Entity spawn(String entityName, double x, double y) {
        return this.spawn(entityName, new SpawnData(x, y));
    }

    public Entity spawn(String entityName, SpawnData data) {
        if (this.entityFactory == null) {
            throw new IllegalStateException("EntityFactory was not set!");
        }
        EntitySpawner spawner = this.entitySpawners.get(entityName);
        if (spawner == null) {
            throw new IllegalArgumentException("EntityFactory does not have a method annotated @Spawns(" + entityName + ")");
        }
        Entity entity = spawner.spawn(data);
        this.addEntity(entity);
        return entity;
    }

    public List<Entity> getEntitiesFiltered(Predicate<Entity> predicate) {
        return this.query.getEntitiesFiltered(predicate);
    }

    public void getEntitiesFiltered(Array<Entity> result, Predicate<Entity> predicate) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            if (!predicate.test(e)) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesByType(Enum<?> ... types) {
        return this.query.getEntitiesByType(types);
    }

    public void getEntitiesByType(Array<Entity> result, Enum<?> ... types) {
        if (types.length == 0) {
            for (int i = 0; i < this.entities.size(); ++i) {
                Entity e = (Entity)this.entities.get(i);
                result.add(e);
            }
            return;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            if (!this.isOfType(e, types)) continue;
            result.add(e);
        }
    }

    private boolean isOfType(Entity e, Enum<?> ... types) {
        TypeComponent entityType = Entities.getType(e);
        if (entityType != null) {
            for (Enum<?> type : types) {
                if (!entityType.isType(type)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Entity> getEntitiesInRange(Rectangle2D selection) {
        return this.query.getEntitiesInRange(selection);
    }

    public void getEntitiesInRange(Array<Entity> result, double minX, double minY, double maxX, double maxY) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            BoundingBoxComponent bbox = Entities.getBBox(e);
            if (bbox == null || !bbox.isWithin(minX, minY, maxX, maxY)) continue;
            result.add(e);
        }
    }

    public List<Entity> getCollidingEntities(Entity entity) {
        return this.query.getCollidingEntities(entity);
    }

    public void getCollidingEntities(Array<Entity> result, Entity entity) {
        BoundingBoxComponent entityBBox = Entities.getBBox(entity);
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            BoundingBoxComponent bbox = Entities.getBBox(e);
            if (bbox == null || !bbox.isCollidingWith(entityBBox) || e == entity) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesByLayer(RenderLayer layer) {
        return this.query.getEntitiesByLayer(layer);
    }

    public void getEntitiesByLayer(Array<Entity> result, RenderLayer layer) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            ViewComponent view = Entities.getView(e);
            if (view == null || view.getRenderLayer().index() != layer.index()) continue;
            result.add(e);
        }
    }

    public List<Entity> getEntitiesAt(Point2D position2) {
        return this.query.getEntitiesAt(position2);
    }

    public void getEntitiesAt(Array<Entity> result, Point2D position2) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity e = (Entity)this.entities.get(i);
            PositionComponent p = Entities.getPosition(e);
            if (p == null || !p.getValue().equals((Object)position2)) continue;
            result.add(e);
        }
    }

    public Optional<Entity> getClosestEntity(Entity entity, Predicate<Entity> filter) {
        Array<Entity> array = new Array<Entity>(false, 64);
        for (Entity e : this.getEntitiesByComponent(PositionComponent.class)) {
            if (!filter.test(e) || e == entity) continue;
            array.add(e);
        }
        if (array.size() == 0) {
            return Optional.empty();
        }
        array.sort((e1, e2) -> (int)(Entities.getPosition(e1).distance(Entities.getPosition(entity)) - Entities.getPosition(e2).distance(Entities.getPosition(entity))));
        return Optional.of(array.get(0));
    }

    public Optional<Entity> getEntityByID(String name, int id) {
        for (Entity e : this.getEntitiesByComponent(IDComponent.class)) {
            IDComponent idComponent = e.getComponentUnsafe(IDComponent.class);
            if (!idComponent.getName().equals(name) || idComponent.getID() != id) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

