/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.entity.component.PositionComponent;

@Required(value=PositionComponent.class)
public final class CircularMovementControl
extends AbstractControl {
    private double radius;
    private double speed;
    private double t = 0.0;
    private PositionComponent position;

    public CircularMovementControl(double speed, double radius) {
        this.radius = radius;
        this.speed = speed;
    }

    @Override
    public void onAdded(Entity entity) {
        this.position = entity.getComponentUnsafe(PositionComponent.class);
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        double x = this.position.getX() - Math.cos(this.t) * this.radius;
        double y = this.position.getY() - Math.sin(this.t) * this.radius;
        this.t += tpf * this.speed;
        this.position.setX(x + Math.cos(this.t) * this.radius);
        this.position.setY(y + Math.sin(this.t) * this.radius);
    }
}

