/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.scene.Viewport;

@Required(value=PositionComponent.class)
public class KeepOnScreenControl
extends AbstractControl {
    private PositionComponent position;
    private BoundingBoxComponent bbox = null;
    private Viewport viewport;
    private boolean horizontally;
    private boolean vertically;

    public KeepOnScreenControl(boolean horizontally, boolean vertically) {
        this.horizontally = horizontally;
        this.vertically = vertically;
    }

    @Override
    public void onAdded(Entity entity) {
        this.position = Entities.getPosition(entity);
        this.bbox = Entities.getBBox(entity);
        this.viewport = FXGL.getApp().getGameScene().getViewport();
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        if (this.bbox == null) {
            this.blockWithoutBBox();
        } else {
            this.blockWithBBox();
        }
    }

    private void blockWithoutBBox() {
        if (this.horizontally) {
            if (this.position.getX() < this.viewport.getX()) {
                this.position.setX(this.viewport.getX());
            } else if (this.position.getX() > this.viewport.getX() + this.viewport.getWidth()) {
                this.position.setX(this.viewport.getX() + this.viewport.getWidth());
            }
        }
        if (this.vertically) {
            if (this.position.getY() < this.viewport.getY()) {
                this.position.setY(this.viewport.getY());
            } else if (this.position.getY() > this.viewport.getY() + this.viewport.getHeight()) {
                this.position.setY(this.viewport.getY() + this.viewport.getHeight());
            }
        }
    }

    private void blockWithBBox() {
        if (this.horizontally) {
            if (this.bbox.getMinXWorld() < this.viewport.getX()) {
                this.position.setX(this.viewport.getX());
            } else if (this.bbox.getMaxXWorld() > this.viewport.getX() + this.viewport.getWidth()) {
                this.position.setX(this.viewport.getX() + this.viewport.getWidth() - this.bbox.getWidth());
            }
        }
        if (this.vertically) {
            if (this.bbox.getMinYWorld() < this.viewport.getY()) {
                this.position.setY(this.viewport.getY());
            } else if (this.bbox.getMaxYWorld() > this.viewport.getY() + this.viewport.getHeight()) {
                this.position.setY(this.viewport.getY() + this.viewport.getHeight() - this.bbox.getHeight());
            }
        }
    }
}

