/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.time.LocalTimer;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/entity/control/RandomMoveControl;", "Lcom/almasb/fxgl/ecs/AbstractControl;", "speed", "", "(D)V", "bbox", "Lcom/almasb/fxgl/entity/component/BoundingBoxComponent;", "delay", "Ljavafx/util/Duration;", "kotlin.jvm.PlatformType", "nextPosition", "Lcom/almasb/fxgl/core/math/Vec2;", "position", "Lcom/almasb/fxgl/entity/component/PositionComponent;", "getSpeed", "()D", "setSpeed", "timer", "Lcom/almasb/fxgl/time/LocalTimer;", "xSeed", "ySeed", "onAdded", "", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "onUpdate", "tpf", "updateNextPosition", "fxgl"})
public final class RandomMoveControl
extends AbstractControl {
    private PositionComponent position;
    private BoundingBoxComponent bbox;
    private final Vec2 nextPosition;
    private double xSeed;
    private double ySeed;
    private final LocalTimer timer;
    private final Duration delay;
    private double speed;

    @Override
    public void onAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        PositionComponent positionComponent = this.position;
        if (positionComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        this.nextPosition.set(positionComponent.getValue());
        this.timer.capture();
    }

    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.xSeed += tpf;
        this.ySeed += tpf;
        PositionComponent positionComponent = this.position;
        if (positionComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        double d = positionComponent.getX();
        PositionComponent positionComponent2 = this.position;
        if (positionComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        if (this.nextPosition.distanceLessThanOrEqual(d, positionComponent2.getY(), this.speed * tpf)) {
            this.updateNextPosition();
        } else {
            PositionComponent positionComponent3 = this.position;
            if (positionComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"position");
            }
            positionComponent3.translateTowards(this.nextPosition.toPoint2D(), this.speed * tpf);
        }
        Duration duration = this.delay;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"delay");
        if (this.timer.elapsed(duration)) {
            this.updateNextPosition();
            this.timer.capture();
        }
    }

    private final void updateNextPosition() {
        BoundingBoxComponent boundingBoxComponent = this.bbox;
        float rangeX = (float)FXGL.Companion.getAppWidth() - (boundingBoxComponent != null ? (float)boundingBoxComponent.getWidth() : 0.0f);
        BoundingBoxComponent boundingBoxComponent2 = this.bbox;
        float rangeY = (float)FXGL.Companion.getAppHeight() - (boundingBoxComponent2 != null ? (float)boundingBoxComponent2.getHeight() : 0.0f);
        this.nextPosition.set(FXGLMath.noise1D(this.xSeed) * rangeX, FXGLMath.noise1D(this.ySeed) * rangeY);
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public RandomMoveControl(double speed) {
        this.speed = speed;
        this.nextPosition = new Vec2();
        this.xSeed = FXGLMath.random(100.0f, 10000.0f);
        this.ySeed = FXGLMath.random(10000.0f, 100000.0f);
        this.timer = FXGL.Companion.newLocalTimer();
        this.delay = Duration.seconds((double)((double)1500 / this.speed));
    }
}

