/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.net.ConnectionMessage;
import com.almasb.fxgl.net.DataParser;
import com.almasb.fxgl.net.NetworkProtocol;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NetworkConnection {
    private static final Logger log = LogManager.getLogger(NetworkConnection.class);
    protected Map<Class<?>, DataParser<? super Serializable>> parsers = new HashMap();
    private ReadOnlyBooleanWrapper connectionActive = new ReadOnlyBooleanWrapper(false);
    private Runnable onConnectionOpen = null;
    private Runnable onConnectionClosed = null;
    private Consumer<Throwable> exceptionHandler = null;

    public Map<Class<?>, DataParser<? super Serializable>> getParsers() {
        return this.parsers;
    }

    public void setParsers(Map<Class<?>, DataParser<? super Serializable>> parsers) {
        this.parsers = parsers;
    }

    public final ReadOnlyBooleanProperty connectionActiveProperty() {
        return this.connectionActive.getReadOnlyProperty();
    }

    public boolean isConnectionActive() {
        return this.connectionActive.get();
    }

    public void setOnConnectionOpen(Runnable onConnectionOpen) {
        this.onConnectionOpen = onConnectionOpen;
    }

    protected void onConnectionOpen() {
        if (this.onConnectionOpen != null) {
            this.onConnectionOpen.run();
        }
        this.connectionActive.set(true);
    }

    public void setOnConnectionClosed(Runnable onConnectionClosed) {
        this.onConnectionClosed = onConnectionClosed;
    }

    protected void onConnectionClosed() {
        if (this.onConnectionClosed != null) {
            this.onConnectionClosed.run();
        }
        this.connectionActive.set(false);
    }

    public void setExceptionHandler(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleError(Exception e) {
        if (this.exceptionHandler == null) {
            throw new RuntimeException("Network error: " + e);
        }
        this.exceptionHandler.accept(e);
    }

    protected void sendClosingMessage() {
        try {
            this.send((Serializable)((Object)ConnectionMessage.CLOSING), NetworkProtocol.TCP);
        }
        catch (Exception e) {
            log.warn("TCP already disconnected or error: " + e.getMessage());
        }
        try {
            this.send((Serializable)((Object)ConnectionMessage.CLOSING), NetworkProtocol.UDP);
        }
        catch (Exception e) {
            log.warn("UDP already disconnected or error: " + e.getMessage());
        }
    }

    public <T extends Serializable> void addParser(Class<T> cl, DataParser<T> parser) {
        this.parsers.put(cl, parser);
    }

    public void send(Serializable data) {
        this.send(data, NetworkProtocol.UDP);
    }

    public void send(Serializable data, NetworkProtocol protocol) {
        if (protocol == NetworkProtocol.TCP) {
            this.sendTCP(data);
        } else {
            this.sendUDP(data);
        }
    }

    protected abstract void sendUDP(Serializable var1);

    protected abstract void sendTCP(Serializable var1);

    public abstract void close();

    protected static byte[] toByteArray(Serializable data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oo = new ObjectOutputStream(baos);){
            oo.writeObject(data);
        }
        return baos.toByteArray();
    }
}

