/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.AbstractComponent;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.ecs.component.RequiredComponents;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyDef;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import javafx.geometry.Point2D;

@RequiredComponents(value={@Required(value=PositionComponent.class), @Required(value=RotationComponent.class), @Required(value=BoundingBoxComponent.class)})
public class PhysicsComponent
extends AbstractComponent {
    FixtureDef fixtureDef = new FixtureDef();
    BodyDef bodyDef = new BodyDef();
    Body body;
    private boolean raycastIgnored = false;
    private Runnable onInitPhysics;
    private final PhysicsWorld physicsWorld = FXGL.getApp().getPhysicsWorld();

    void onInitPhysics() {
        if (this.onInitPhysics != null) {
            this.onInitPhysics.run();
        }
    }

    public final Body getBody() {
        if (this.body == null) {
            throw new IllegalStateException("Physics not initialized yet! Use setOnPhysicsInitialized() instead");
        }
        return this.body;
    }

    public void setOnPhysicsInitialized(Runnable code) {
        this.onInitPhysics = code;
    }

    public void setFixtureDef(FixtureDef def) {
        this.fixtureDef = def;
    }

    public void setBodyDef(BodyDef def) {
        this.bodyDef = def;
    }

    public void setBodyType(BodyType type) {
        this.bodyDef.setType(type);
    }

    public void setLinearVelocity(Point2D vector) {
        this.setBodyLinearVelocity(this.physicsWorld.toVector(vector));
    }

    public void setLinearVelocity(double x, double y) {
        this.setLinearVelocity(new Point2D(x, y));
    }

    public void setVelocityX(double x) {
        this.setLinearVelocity(x, this.getVelocityY());
    }

    public void setVelocityY(double y) {
        this.setLinearVelocity(this.getVelocityX(), y);
    }

    public double getVelocityX() {
        return this.getLinearVelocity().getX();
    }

    public double getVelocityY() {
        return this.getLinearVelocity().getY();
    }

    public void setBodyLinearVelocity(Vec2 vector) {
        this.getBody().setLinearVelocity(vector);
    }

    public Point2D getLinearVelocity() {
        return this.physicsWorld.toVector(this.getBody().getLinearVelocity());
    }

    public void setAngularVelocity(double velocity) {
        this.getBody().setAngularVelocity((float)(-velocity));
    }

    public void applyLinearImpulse(Point2D impulse, Point2D point, boolean wake) {
        this.applyBodyLinearImpulse(this.physicsWorld.toVector(impulse), this.physicsWorld.toPoint(point), wake);
    }

    public void applyBodyLinearImpulse(Vec2 impulse, Vec2 point, boolean wake) {
        this.getBody().applyLinearImpulse(impulse, point, wake);
    }

    public void applyForce(Point2D force, Point2D point) {
        this.applyBodyForce(this.physicsWorld.toVector(force), this.physicsWorld.toPoint(point));
    }

    public void applyBodyForce(Vec2 force, Vec2 point) {
        this.getBody().applyForce(force, point);
    }

    public void applyForceToCenter(Point2D force) {
        this.applyBodyForceToCenter(this.physicsWorld.toVector(force));
    }

    public void applyBodyForceToCenter(Vec2 force) {
        this.getBody().applyForceToCenter(force);
    }

    public void applyAngularImpulse(float impulse) {
        this.applyBodyAngularImpulse(this.physicsWorld.toMeters(impulse));
    }

    public void applyBodyAngularImpulse(float impulse) {
        this.getBody().applyAngularImpulse(impulse);
    }

    public void applyTorque(float torque) {
        this.applyBodyTorque(this.physicsWorld.toMeters(torque));
    }

    public void applyBodyTorque(float torque) {
        this.getBody().applyTorque(torque);
    }

    public void setRaycastIgnored(boolean b) {
        this.raycastIgnored = b;
    }

    public boolean isRaycastIgnored() {
        return this.raycastIgnored;
    }
}

