/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.AbstractControl;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import javafx.geometry.Point2D;

@Required(value=PhysicsComponent.class)
public class PhysicsControl
extends AbstractControl {
    private Body body;
    private PhysicsWorld physicsWorld;
    private PositionComponent position;
    private RotationComponent rotation;
    private BoundingBoxComponent bbox;
    private double appHeight;

    PhysicsControl(double appHeight) {
        this.appHeight = appHeight;
        this.physicsWorld = FXGL.getApp().getPhysicsWorld();
    }

    @Override
    public void onAdded(Entity entity) {
        this.position = Entities.getPosition(entity);
        this.rotation = Entities.getRotation(entity);
        this.bbox = Entities.getBBox(entity);
        this.body = entity.getComponentUnsafe(PhysicsComponent.class).body;
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        this.position.setX(Math.round(this.toPixels(this.body.getPosition().x - this.toMeters(this.bbox.getWidth() / 2.0))));
        this.position.setY(Math.round(this.toPixels(this.toMeters(this.appHeight) - this.body.getPosition().y - this.toMeters(this.bbox.getHeight() / 2.0))));
        this.rotation.setValue(-Math.toDegrees(this.body.getAngle()));
    }

    public void reposition(Point2D point) {
        double w = this.bbox.getWidth();
        double h = this.bbox.getHeight();
        this.body.setTransform(new Vec2(this.toMeters(point.getX() + w / 2.0), this.toMeters(this.appHeight - (point.getY() + h / 2.0))), this.body.getAngle());
    }

    private float toMeters(double pixels) {
        return this.physicsWorld.toMeters(pixels);
    }

    private float toPixels(double meters) {
        return this.physicsWorld.toPixels(meters);
    }
}

