/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.effect.ParticleControl;
import com.almasb.fxgl.physics.PhysicsParticle;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroup;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/physics/PhysicsParticleControl;", "Lcom/almasb/fxgl/effect/ParticleControl;", "group", "Lcom/almasb/fxgl/physics/box2d/particle/ParticleGroup;", "color", "Ljavafx/scene/paint/Color;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "(Lcom/almasb/fxgl/physics/box2d/particle/ParticleGroup;Ljavafx/scene/paint/Color;Lcom/almasb/fxgl/physics/PhysicsWorld;)V", "radiusMeters", "", "radiusPixels", "onRemoved", "", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "onUpdate", "tpf", "fxgl"})
public final class PhysicsParticleControl
extends ParticleControl {
    private double radiusMeters;
    private double radiusPixels;
    private final ParticleGroup group;
    private final Color color;
    private final PhysicsWorld physicsWorld;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.particles.clear();
        Vec2[] centers = this.physicsWorld.getJBox2DWorld().getParticleSystem().getParticlePositionBuffer();
        int n = this.group.getBufferIndex();
        int n2 = this.group.getBufferIndex() + this.group.getParticleCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Vec2 center = centers[i];
                double x = this.physicsWorld.toPixels((double)center.x - this.radiusMeters);
                double y = this.physicsWorld.toPixels((double)this.physicsWorld.toMeters(this.physicsWorld.getAppHeight()) - (double)center.y - this.radiusMeters);
                this.particles.add(new PhysicsParticle(new Point2D(x, y), this.radiusPixels, (Paint)this.color));
                if (i == n2) break;
                ++i;
            }
        }
    }

    @Override
    public void onRemoved(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.physicsWorld.getJBox2DWorld().destroyParticlesInGroup(this.group);
        super.onRemoved(entity);
    }

    public PhysicsParticleControl(@NotNull ParticleGroup group, @NotNull Color color, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)physicsWorld, (String)"physicsWorld");
        this.group = group;
        this.color = color;
        this.physicsWorld = physicsWorld;
        this.radiusMeters = this.physicsWorld.getJBox2DWorld().getParticleSystem().getParticleRadius();
        this.radiusPixels = this.physicsWorld.toPixels(this.radiusMeters);
    }
}

