/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.saving;

import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.io.serialization.Bundle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UserProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private String appTitle;
    private String appVersion;

    public UserProfile(String appTitle, String appVersion) {
        this.appTitle = appTitle;
        this.appVersion = appVersion;
    }

    public final boolean isCompatible(String appTitle, String appVersion) {
        return this.appTitle.equals(appTitle) && this.appVersion.equals(appVersion);
    }

    public final void putBundle(Bundle bundle) {
        if (this.bundles.containsKey(bundle.getName())) {
            throw new IllegalArgumentException("Bundle \"" + bundle.getName() + "\" already exists!");
        }
        this.bundles.put(bundle.getName(), bundle);
    }

    public final Bundle getBundle(String name) {
        Bundle bundle = this.bundles.get(name);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + name + "\" doesn't exist!");
        }
        return bundle;
    }

    public final void log(Logger logger) {
        logger.info("Logging profile data");
        logger.info(this.bundles.toString());
    }
}

