/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene.lighting;

import com.almasb.fxgl.scene.lighting.Segment;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/scene/lighting/Intersection;", "", "point", "Ljavafx/geometry/Point2D;", "distance", "", "(Ljavafx/geometry/Point2D;D)V", "getDistance", "()D", "getPoint", "()Ljavafx/geometry/Point2D;", "Companion", "fxgl"})
public final class Intersection {
    @NotNull
    private final Point2D point;
    private final double distance;
    @NotNull
    private static final Intersection NONE;
    public static final Companion Companion;

    @NotNull
    public final Point2D getPoint() {
        return this.point;
    }

    public final double getDistance() {
        return this.distance;
    }

    public Intersection(@NotNull Point2D point, double distance) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        this.point = point;
        this.distance = distance;
    }

    static {
        Companion = new Companion(null);
        NONE = new Intersection(new Point2D(100.0, 100.0), Double.MAX_VALUE);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/scene/lighting/Intersection$Companion;", "", "()V", "NONE", "Lcom/almasb/fxgl/scene/lighting/Intersection;", "getNONE", "()Lcom/almasb/fxgl/scene/lighting/Intersection;", "intersect", "ray", "Lcom/almasb/fxgl/scene/lighting/Segment;", "segment", "fxgl"})
    public static final class Companion {
        @NotNull
        public final Intersection getNONE() {
            return NONE;
        }

        @NotNull
        public final Intersection intersect(@NotNull Segment ray, @NotNull Segment segment) {
            Intrinsics.checkParameterIsNotNull((Object)ray, (String)"ray");
            Intrinsics.checkParameterIsNotNull((Object)segment, (String)"segment");
            double rayLength = ray.magnitude();
            double segmentLength = segment.magnitude();
            if (ray.getTo().getX() / rayLength == segment.getTo().getX() / segmentLength && ray.getTo().getY() / rayLength == segment.getTo().getY() / segmentLength) {
                return this.getNONE();
            }
            double T2 = (ray.getTo().getX() * (segment.getFrom().getY() - ray.getFrom().getY()) + ray.getTo().getY() * (ray.getFrom().getX() - segment.getFrom().getX())) / (segment.getTo().getX() * ray.getTo().getY() - segment.getTo().getY() * ray.getTo().getX());
            double T1 = (segment.getFrom().getX() + segment.getTo().getX() * T2 - ray.getFrom().getX()) / ray.getTo().getX();
            if (T1 < 0.0 || T2 < 0.0 || T2 > 1.0) {
                return this.getNONE();
            }
            return new Intersection(new Point2D(ray.getFrom().getX() + ray.getTo().getX() * T1, ray.getFrom().getY() + ray.getTo().getY() * T1), T1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

