/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.Disposable;
import com.almasb.fxgl.texture.AnimatedTexture;
import com.almasb.fxgl.texture.AnimationChannel;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class Texture
extends ImageView
implements Disposable {
    public Texture(Image image) {
        super(image);
    }

    public final AnimatedTexture toAnimatedTexture(int frames, Duration duration) {
        return this.toAnimatedTexture(new AnimationChannel(this.getImage(), frames, (int)this.getImage().getWidth() / frames, (int)this.getImage().getHeight(), duration, 0, frames - 1));
    }

    public final AnimatedTexture toAnimatedTexture(AnimationChannel defaultChannel) {
        return new AnimatedTexture(defaultChannel);
    }

    public final Texture copy() {
        return new Texture(this.getImage());
    }

    public final Texture subTexture(Rectangle2D area) {
        int minX = (int)area.getMinX();
        int minY = (int)area.getMinY();
        int maxX = (int)area.getMaxX();
        int maxY = (int)area.getMaxY();
        if (minX < 0) {
            throw new IllegalArgumentException("minX value of sub-texture cannot be negative");
        }
        if (minY < 0) {
            throw new IllegalArgumentException("minY value of sub-texture cannot be negative");
        }
        if ((double)maxX > this.getImage().getWidth()) {
            throw new IllegalArgumentException("maxX value of sub-texture cannot be greater than image width");
        }
        if ((double)maxY > this.getImage().getHeight()) {
            throw new IllegalArgumentException("maxY value of sub-texture cannot be greater than image height");
        }
        PixelReader pixelReader = this.getImage().getPixelReader();
        WritableImage image = new WritableImage(maxX - minX, maxY - minY);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                Color color = pixelReader.getColor(x, y);
                pixelWriter.setColor(x - minX, y - minY, color);
            }
        }
        return new Texture((Image)image);
    }

    public final Texture superTexture(Texture other, HorizontalDirection direction) {
        Image rightImage;
        Image leftImage;
        if (direction == HorizontalDirection.LEFT) {
            leftImage = other.getImage();
            rightImage = this.getImage();
        } else {
            leftImage = this.getImage();
            rightImage = other.getImage();
        }
        int width = (int)(leftImage.getWidth() + rightImage.getWidth());
        int height = (int)Math.max(leftImage.getHeight(), rightImage.getHeight());
        PixelReader leftReader = leftImage.getPixelReader();
        PixelReader rightReader = rightImage.getPixelReader();
        WritableImage image = new WritableImage(width, height);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = (double)x < leftImage.getWidth() ? ((double)y < leftImage.getHeight() ? leftReader.getColor(x, y) : Color.TRANSPARENT) : ((double)y < rightImage.getHeight() ? rightReader.getColor(x - (int)leftImage.getWidth(), y) : Color.TRANSPARENT);
                pixelWriter.setColor(x, y, color);
            }
        }
        return new Texture((Image)image);
    }

    public final Texture superTexture(Texture other, VerticalDirection direction) {
        Image bottomImage;
        Image topImage;
        if (direction == VerticalDirection.DOWN) {
            topImage = this.getImage();
            bottomImage = other.getImage();
        } else {
            topImage = other.getImage();
            bottomImage = this.getImage();
        }
        int width = (int)Math.max(topImage.getWidth(), bottomImage.getWidth());
        int height = (int)(topImage.getHeight() + bottomImage.getHeight());
        PixelReader topReader = topImage.getPixelReader();
        PixelReader bottomReader = bottomImage.getPixelReader();
        WritableImage image = new WritableImage(width, height);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = (double)y < topImage.getHeight() ? ((double)x < topImage.getWidth() ? topReader.getColor(x, y) : Color.TRANSPARENT) : ((double)x < bottomImage.getWidth() ? bottomReader.getColor(x, y - (int)topImage.getHeight()) : Color.TRANSPARENT);
                pixelWriter.setColor(x, y, color);
            }
        }
        return new Texture((Image)image);
    }

    public final Texture toGrayscale() {
        int w = (int)this.getImage().getWidth();
        int h = (int)this.getImage().getHeight();
        PixelReader reader = this.getImage().getPixelReader();
        WritableImage image = new WritableImage(w, h);
        PixelWriter writer = image.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                writer.setColor(x, y, reader.getColor(x, y).grayscale());
            }
        }
        return new Texture((Image)image);
    }

    public final Texture discolor() {
        int w = (int)this.getImage().getWidth();
        int h = (int)this.getImage().getHeight();
        PixelReader reader = this.getImage().getPixelReader();
        WritableImage image = new WritableImage(w, h);
        PixelWriter writer = image.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                double opacity = reader.getColor(x, y).getOpacity();
                writer.setColor(x, y, Color.color((double)1.0, (double)1.0, (double)1.0, (double)opacity));
            }
        }
        return new Texture((Image)image);
    }

    public final Texture multiplyColor(Color color) {
        int w = (int)this.getImage().getWidth();
        int h = (int)this.getImage().getHeight();
        PixelReader reader = this.getImage().getPixelReader();
        WritableImage coloredImage = new WritableImage(w, h);
        PixelWriter writer = coloredImage.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color c = reader.getColor(x, y);
                c = Color.color((double)(c.getRed() * color.getRed()), (double)(c.getGreen() * color.getGreen()), (double)(c.getBlue() * color.getBlue()), (double)(c.getOpacity() * color.getOpacity()));
                writer.setColor(x, y, c);
            }
        }
        return new Texture((Image)coloredImage);
    }

    public final Texture toColor(Color color) {
        Texture discolored = this.discolor();
        Texture colored = discolored.multiplyColor(color);
        discolored.dispose();
        return colored;
    }

    public final void set(Texture other) {
        this.setFitWidth(other.getFitWidth());
        this.setFitHeight(other.getFitHeight());
        this.setImage(other.getImage());
    }

    @Override
    public void dispose() {
        this.setImage(null);
    }

    public String toString() {
        return "Texture [fitWidth=" + this.getFitWidth() + ", fitHeight=" + this.getFitHeight() + "]";
    }
}

