/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.entity.component.ViewComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0017\u001a\u00020\u0018J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u00042\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/entity/GameWorldQuery;", "", "entities", "", "Lcom/almasb/fxgl/ecs/Entity;", "(Ljava/util/List;)V", "getCollidingEntities", "entity", "getEntitiesAt", "position", "Ljavafx/geometry/Point2D;", "getEntitiesByLayer", "layer", "Lcom/almasb/fxgl/entity/RenderLayer;", "getEntitiesByType", "types", "", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "Ljava/util/function/Predicate;", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "isOneOfTypes", "", "(Lcom/almasb/fxgl/ecs/Entity;[Ljava/lang/Enum;)Z", "fxgl"})
public final class GameWorldQuery {
    private final List<Entity> entities;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Object[] objectArray = types;
        if (objectArray.length == 0) {
            return new ArrayList(this.entities);
        }
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        TypeComponent entityType = Entities.getType(entity);
        if (entityType != null) {
            boolean bl;
            block2: {
                Object[] $receiver$iv = types;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    Enum it = (Enum)element$iv;
                    if (!entityType.isType(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            BoundingBoxComponent boundingBoxComponent = it.getComponent(BoundingBoxComponent.class);
            if (!(boundingBoxComponent != null ? boundingBoxComponent.isWithin(selection) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        BoundingBoxComponent bbox = Entities.getBBox(entity);
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            BoundingBoxComponent boundingBoxComponent = it.getComponent(BoundingBoxComponent.class);
            if (!((boundingBoxComponent != null ? boundingBoxComponent.isCollidingWith(bbox) : false) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByLayer(@NotNull RenderLayer layer) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)layer, (String)"layer");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            ViewComponent view = it.getComponent(ViewComponent.class);
            boolean bl = view != null ? view.getRenderLayer().index() == layer.index() : false;
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesAt(@NotNull Point2D position2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            Entity it = (Entity)element$iv$iv;
            PositionComponent positionComponent = it.getComponent(PositionComponent.class);
            if (positionComponent == null || (positionComponent = positionComponent.getValue()) == null) {
                bl = false;
            } else {
                PositionComponent p = positionComponent;
                bl = Intrinsics.areEqual((Object)p, (Object)position2);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public GameWorldQuery(@NotNull List<? extends Entity> entities) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        this.entities = entities;
    }
}

