/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene.lighting;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.scene.lighting.Intersection;
import com.almasb.fxgl.scene.lighting.LightingSystem;
import com.almasb.fxgl.scene.lighting.LightingSystemKt;
import com.almasb.fxgl.scene.lighting.Segment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J,\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120(H\u0002J\u0006\u0010*\u001a\u00020\u001aJ\u0006\u0010+\u001a\u00020\u001aR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u000ej\b\u0012\u0004\u0012\u00020\u0012`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/almasb/fxgl/scene/lighting/LightingSystem;", "", "()V", "f", "", "getF", "()I", "setF", "(I)V", "gameRoot", "Ljavafx/scene/Group;", "light", "Ljavafx/scene/layout/Pane;", "objectPoints", "Ljava/util/ArrayList;", "Ljavafx/geometry/Point2D;", "Lkotlin/collections/ArrayList;", "objectSegments", "Lcom/almasb/fxgl/scene/lighting/Segment;", "obstaclePoints", "Ljava/util/HashSet;", "obstacleSegments", "shadow", "Ljavafx/scene/shape/Shape;", "walls", "addObstacle", "", "node", "Ljavafx/scene/Node;", "points", "", "([Ljavafx/geometry/Point2D;)V", "init", "lightRoot", "onAddEntity", "entity", "Lcom/almasb/fxgl/ecs/Entity;", "renderRay", "Ljavafx/scene/shape/Polygon;", "mp", "", "segmentSet", "renderRays", "update", "fxgl"})
public final class LightingSystem {
    private Shape shadow;
    private Group gameRoot;
    private final HashSet<Point2D> obstaclePoints = new HashSet();
    private final HashSet<Segment> obstacleSegments = new HashSet();
    private final ArrayList<Point2D> objectPoints;
    private final ArrayList<Segment> objectSegments;
    private final Pane walls;
    private final Pane light;
    private int f;

    public final void init(@NotNull Group lightRoot, @NotNull Group gameRoot) {
        Intrinsics.checkParameterIsNotNull((Object)lightRoot, (String)"lightRoot");
        Intrinsics.checkParameterIsNotNull((Object)gameRoot, (String)"gameRoot");
        this.gameRoot = gameRoot;
        Shape shape = this.shadow = (Shape)new Rectangle((double)FXGL.Companion.getApp().getWidth(), (double)FXGL.Companion.getApp().getHeight(), (Paint)Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5));
        if (shape == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadow");
        }
        shape.setBlendMode(BlendMode.DARKEN);
        ObservableList observableList = lightRoot.getChildren();
        Object[] objectArray = new Node[3];
        objectArray[0] = (Node)this.walls;
        Shape shape2 = this.shadow;
        if (shape2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadow");
        }
        objectArray[1] = (Node)shape2;
        objectArray[2] = (Node)this.light;
        observableList.addAll(objectArray);
        this.addObstacle(new Point2D(0.0, 0.0), new Point2D((double)FXGL.Companion.getApp().getWidth(), 0.0), new Point2D((double)FXGL.Companion.getApp().getWidth(), (double)FXGL.Companion.getApp().getHeight()), new Point2D(0.0, (double)FXGL.Companion.getApp().getHeight()));
    }

    public final void addObstacle(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.walls.getChildren().add((Object)node);
    }

    public final int getF() {
        return this.f;
    }

    public final void setF(int n) {
        this.f = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void addObstacle(Point2D ... points) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)points, (String)"points");
        if (((Object[])points).length < 3) {
            throw (Throwable)new IllegalArgumentException("Cannot create a polygon with < 3 points");
        }
        CollectionsKt.addAll((Collection)this.obstaclePoints, (Object[])points);
        Iterable $receiver$iv2 = ArraysKt.zip((Object[])points, (Iterable)CollectionsKt.plus((Collection)ArraysKt.drop((Object[])points, (int)1), (Object)points[0]));
        Iterable iterable = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            Segment segment = new Segment((Point2D)it.getFirst(), (Point2D)it.getSecond());
            collection.add(segment);
        }
        List segments = (List)destination$iv$iv;
        this.obstacleSegments.addAll(segments);
        if (this.f == 0) {
            int $receiver$iv2 = this.f;
            this.f = $receiver$iv2 + 1;
            return;
        }
        Polygon polygon = new Polygon();
        Object[] $receiver$iv3 = points;
        for (int i = 0; i < $receiver$iv3.length; ++i) {
            Object element$iv = $receiver$iv3[i];
            Point2D it = (Point2D)element$iv;
            polygon.getPoints().add((Object)it.getX());
            polygon.getPoints().add((Object)it.getY());
        }
        this.addObstacle((Node)polygon);
    }

    public final void onAddEntity(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!entity.hasComponent(BoundingBoxComponent.class)) {
            return;
        }
        ArrayList points = CollectionsKt.arrayListOf((Object[])new Point2D[]{LightingSystemKt.topLeft(entity), LightingSystemKt.topRight(entity), LightingSystemKt.botRight(entity), LightingSystemKt.botLeft(entity)});
        this.objectPoints.addAll(points);
        for (int i = 0; i < points.size(); i += 4) {
            Object e = points.get(i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"points[i]");
            Point2D point2D = (Point2D)e;
            Object e2 = points.get(i + 1);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"points[i + 1]");
            this.objectSegments.add(new Segment(point2D, (Point2D)e2));
            Object e3 = points.get(i + 1);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"points[i + 1]");
            Point2D point2D2 = (Point2D)e3;
            Object e4 = points.get(i + 2);
            Intrinsics.checkExpressionValueIsNotNull(e4, (String)"points[i + 2]");
            this.objectSegments.add(new Segment(point2D2, (Point2D)e4));
            Object e5 = points.get(i + 2);
            Intrinsics.checkExpressionValueIsNotNull(e5, (String)"points[i + 2]");
            Point2D point2D3 = (Point2D)e5;
            Object e6 = points.get(i + 3);
            Intrinsics.checkExpressionValueIsNotNull(e6, (String)"points[i + 3]");
            this.objectSegments.add(new Segment(point2D3, (Point2D)e6));
            Object e7 = points.get(i + 3);
            Intrinsics.checkExpressionValueIsNotNull(e7, (String)"points[i + 3]");
            Point2D point2D4 = (Point2D)e7;
            Object e8 = points.get(i);
            Intrinsics.checkExpressionValueIsNotNull(e8, (String)"points[i]");
            this.objectSegments.add(new Segment(point2D4, (Point2D)e8));
        }
    }

    public final void update() {
        this.renderRays();
    }

    /*
     * WARNING - void declaration
     */
    private final Polygon renderRay(Point2D mp, Set<? extends Point2D> points, Set<Segment> segmentSet) {
        Object object;
        Collection collection;
        Iterable $receiver$iv$iv;
        Polygon lightPoly = new Polygon();
        Iterable $receiver$iv = points;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            Point2D point2D = (Point2D)item$iv$iv;
            collection = destination$iv$iv;
            object = Math.atan2(p.getY() - mp.getY(), p.getX() - mp.getX());
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            double a = ((Number)element$iv$iv).doubleValue();
            Iterable list$iv$iv = CollectionsKt.arrayListOf((Object[])new Double[]{a - 1.0E-4, a, a + 1.0E-4});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            double a = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            Segment s = new Segment(mp, new Point2D(mp.getX() + Math.cos(a), mp.getY() + Math.sin(a)));
            Iterable $i$f$flatMapTo = $receiver$iv2 = (Iterable)segmentSet;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void ss;
                Segment segment = (Segment)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                Intersection intersection = Intersection.Companion.intersect(s, (Segment)ss);
                collection2.add(intersection);
            }
            object = (Intersection)CollectionsKt.minWith((Iterable)((List)destination$iv$iv2), (Comparator)renderRay.3.2.INSTANCE);
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Intersection i = (Intersection)element$iv$iv;
            if (!(i != Intersection.Companion.getNONE())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Intersection i = (Intersection)item$iv$iv;
            collection = destination$iv$iv;
            void v0 = it;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            object = v0.getPoint();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Point2D it = (Point2D)element$iv;
            lightPoly.getPoints().add((Object)it.getX());
            lightPoly.getPoints().add((Object)it.getY());
        }
        lightPoly.setFill((Paint)new RadialGradient(0.0, 0.0, mp.getX(), mp.getY(), 700.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.valueOf((String)"#FFFFFFFF")), new Stop(1.0, Color.valueOf((String)"#33333300"))}));
        lightPoly.setBlendMode(BlendMode.SOFT_LIGHT);
        return lightPoly;
    }

    /*
     * WARNING - void declaration
     */
    public final void renderRays() {
        Iterable $receiver$iv;
        Iterator iterator$iv;
        this.light.getChildren().clear();
        ArrayList<Polygon> rays = new ArrayList<Polygon>();
        double mx = FXGL.Companion.getInput().getMouseXUI();
        double my = FXGL.Companion.getInput().getMouseYUI();
        int n = 0;
        int n2 = 7;
        if (n <= n2) {
            while (true) {
                void i;
                Polygon beam = this.renderRay(new Point2D(mx + Math.cos((double)i / 8.0 * (Math.PI * 2)) * 7.0, my + Math.sin((double)i / 8.0 * (Math.PI * 2)) * 7.0), (Set<? extends Point2D>)this.obstaclePoints, (Set<Segment>)this.obstacleSegments);
                rays.add(beam);
                if (i == n2) break;
                ++i;
            }
        }
        if (!(iterator$iv = ($receiver$iv = (Iterable)rays).iterator()).hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv22 = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void shape2;
            Shape shape = (Shape)iterator$iv.next();
            Shape shape1 = (Shape)accumulator$iv22;
            Intrinsics.checkExpressionValueIsNotNull((Object)Shape.union((Shape)shape1, (Shape)shape2), (String)"Shape.union(shape1, shape2)");
        }
        Shape clip = (Shape)accumulator$iv22;
        Group group = this.gameRoot;
        if (group == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameRoot");
        }
        group.setClip((Node)clip);
        rays.clear();
        HashSet combinedPoints = new HashSet(this.obstaclePoints);
        combinedPoints.addAll(this.objectPoints);
        HashSet combinedSegments = new HashSet(this.obstacleSegments);
        combinedSegments.addAll(this.objectSegments);
        int accumulator$iv22 = 0;
        int n3 = 7;
        if (accumulator$iv22 <= n3) {
            while (true) {
                void i;
                Polygon beam = this.renderRay(new Point2D(mx + Math.cos((double)i / 8.0 * (Math.PI * 2)) * 7.0, my + Math.sin((double)i / 8.0 * (Math.PI * 2)) * 7.0), combinedPoints, combinedSegments);
                rays.add(beam);
                if (i == n3) break;
                ++i;
            }
        }
        this.light.getChildren().addAll((Collection)rays);
    }

    public LightingSystem() {
        LightingSystem lightingSystem = this;
        ArrayList arrayList = new ArrayList();
        lightingSystem.objectPoints = arrayList;
        lightingSystem = this;
        arrayList = new ArrayList();
        lightingSystem.objectSegments = arrayList;
        this.walls = new Pane();
        this.light = new Pane();
    }
}

