/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.animation.AnimatedCubicBezierPoint2D;
import com.almasb.fxgl.animation.AnimatedPoint2D;
import com.almasb.fxgl.animation.AnimatedQuadBezierPoint2D;
import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/entity/animation/TranslationAnimationBuilder;", "", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;)V", "fromPoint", "Ljavafx/geometry/Point2D;", "kotlin.jvm.PlatformType", "path", "Ljavafx/scene/shape/Shape;", "toPoint", "alongPath", "build", "Lcom/almasb/fxgl/animation/Animation;", "buildAndPlay", "from", "start", "makeAnim", "animValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "to", "end", "fxgl"})
public final class TranslationAnimationBuilder {
    private Shape path;
    private Point2D fromPoint;
    private Point2D toPoint;
    private final AnimationBuilder animationBuilder;

    @NotNull
    public final TranslationAnimationBuilder alongPath(@NotNull Shape path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        return this;
    }

    @NotNull
    public final TranslationAnimationBuilder from(@NotNull Point2D start2) {
        Intrinsics.checkParameterIsNotNull((Object)start2, (String)"start");
        this.fromPoint = start2;
        return this;
    }

    @NotNull
    public final TranslationAnimationBuilder to(@NotNull Point2D end) {
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        this.toPoint = end;
        return this;
    }

    @NotNull
    public final Animation<?> build() {
        Shape shape = this.path;
        if (shape != null) {
            Shape shape2 = shape;
            Shape curve = shape2;
            Shape shape3 = curve;
            if (shape3 instanceof QuadCurve) {
                return this.makeAnim(new AnimatedQuadBezierPoint2D((QuadCurve)curve));
            }
            if (shape3 instanceof CubicCurve) {
                return this.makeAnim(new AnimatedCubicBezierPoint2D((CubicCurve)curve));
            }
            throw (Throwable)new IllegalArgumentException("Unsupported path: " + curve);
        }
        Point2D point2D = this.fromPoint;
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"fromPoint");
        Point2D point2D2 = this.toPoint;
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"toPoint");
        Interpolator interpolator = this.animationBuilder.getInterpolator();
        Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"animationBuilder.interpolator");
        return this.makeAnim(new AnimatedPoint2D(point2D, point2D2, interpolator));
    }

    private final Animation<Point2D> makeAnim(AnimatedValue<Point2D> animValue) {
        Duration duration = this.animationBuilder.getDelay();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"animationBuilder.delay");
        Duration duration2 = this.animationBuilder.getDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"animationBuilder.duration");
        return new Animation<Point2D>(this, animValue, duration, duration2, this.animationBuilder.getTimes(), animValue){
            final /* synthetic */ TranslationAnimationBuilder this$0;
            final /* synthetic */ AnimatedValue $animValue;

            public void onProgress(@NotNull Point2D value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Iterable $receiver$iv = TranslationAnimationBuilder.access$getAnimationBuilder$p(this.this$0).getEntities();
                for (T element$iv : $receiver$iv) {
                    GameEntity it = (GameEntity)element$iv;
                    it.setPosition(value);
                }
            }
            {
                this.this$0 = $outer;
                this.$animValue = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    @NotNull
    public final Animation<?> buildAndPlay() {
        Animation<?> anim = this.build();
        anim.startInPlayState();
        return anim;
    }

    public TranslationAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        this.animationBuilder = animationBuilder;
        this.fromPoint = Point2D.ZERO;
        this.toPoint = Point2D.ZERO;
    }

    @NotNull
    public static final /* synthetic */ AnimationBuilder access$getAnimationBuilder$p(TranslationAnimationBuilder $this) {
        return $this.animationBuilder;
    }
}

