/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.ecs.Component;
import com.almasb.fxgl.ecs.CopyableComponent;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.ecs.serialization.SerializableComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.RotationComponent;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.SAT;
import com.almasb.fxgl.service.Pooler;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.jetbrains.annotations.NotNull;

@Required(value=PositionComponent.class)
public class BoundingBoxComponent
extends Component
implements SerializableComponent,
CopyableComponent<BoundingBoxComponent> {
    private static final Pooler pooler = FXGL.getPooler();
    private PositionComponent position;
    private ObservableList<HitBox> hitBoxes = FXCollections.observableArrayList();
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper minXLocal = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper minYLocal = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper minXWorld = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper minYWorld = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper maxXWorld = new ReadOnlyDoubleWrapper();
    private ReadOnlyDoubleWrapper maxYWorld = new ReadOnlyDoubleWrapper();
    private ListChangeListener<? super HitBox> onHitBoxChange = c -> {
        this.minXLocal.set(this.computeMinXLocal());
        this.minYLocal.set(this.computeMinYLocal());
        this.width.set(this.computeWidth());
        this.height.set(this.computeHeight());
        while (c.next()) {
            if (c.wasAdded()) {
                if (this.position == null) continue;
                for (HitBox box : c.getAddedSubList()) {
                    box.bindX(this.position.xProperty());
                    box.bindY(this.position.yProperty());
                }
                continue;
            }
            if (!c.wasRemoved()) continue;
            for (HitBox box : c.getRemoved()) {
                box.unbind();
            }
        }
    };

    public BoundingBoxComponent(HitBox ... boxes) {
        this.hitBoxes.addAll((Object[])boxes);
        this.minXLocal.set(this.computeMinXLocal());
        this.minYLocal.set(this.computeMinYLocal());
        this.width.set(this.computeWidth());
        this.height.set(this.computeHeight());
        this.hitBoxes.addListener(this.onHitBoxChange);
    }

    @Override
    public void onAdded(Entity entity) {
        this.position = entity.getComponent(PositionComponent.class);
        this.minXWorld.bind((ObservableValue)this.minXLocal.add((ObservableNumberValue)this.position.xProperty()));
        this.minYWorld.bind((ObservableValue)this.minYLocal.add((ObservableNumberValue)this.position.yProperty()));
        this.maxXWorld.bind((ObservableValue)this.minXLocal.add((ObservableNumberValue)this.position.xProperty()).add((ObservableNumberValue)this.width));
        this.maxYWorld.bind((ObservableValue)this.minYLocal.add((ObservableNumberValue)this.position.yProperty()).add((ObservableNumberValue)this.height));
        for (int i = 0; i < this.hitBoxes.size(); ++i) {
            ((HitBox)this.hitBoxes.get(i)).bindX(this.position.xProperty());
            ((HitBox)this.hitBoxes.get(i)).bindX(this.position.yProperty());
        }
    }

    @Override
    public void onRemoved(Entity entity) {
        this.hitBoxes.removeListener(this.onHitBoxChange);
        for (int i = 0; i < this.hitBoxes.size(); ++i) {
            ((HitBox)this.hitBoxes.get(i)).unbind();
        }
        this.minXWorld.unbind();
        this.minYWorld.unbind();
        this.maxXWorld.unbind();
        this.maxYWorld.unbind();
    }

    public final ObservableList<HitBox> hitBoxesProperty() {
        return FXCollections.unmodifiableObservableList(this.hitBoxes);
    }

    public final void addHitBox(HitBox hitBox) {
        this.hitBoxes.add((Object)hitBox);
    }

    public final void removeHitBox(String name) {
        this.hitBoxes.removeIf(h -> h.getName().equals(name));
    }

    public final void clearHitBoxes() {
        this.hitBoxes.clear();
    }

    public double getWidth() {
        return this.width.get();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public double getHeight() {
        return this.height.get();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    private double computeWidth() {
        return this.hitBoxes.stream().mapToDouble(h -> h.getBounds().getMaxX() - this.getMinXLocal()).max().orElse(0.0);
    }

    private double computeHeight() {
        return this.hitBoxes.stream().mapToDouble(h -> h.getBounds().getMaxY() - this.getMinYLocal()).max().orElse(0.0);
    }

    public ReadOnlyDoubleProperty minXLocalProperty() {
        return this.minXLocal.getReadOnlyProperty();
    }

    public double getMinXLocal() {
        return this.minXLocal.get();
    }

    public ReadOnlyDoubleProperty minYLocalProperty() {
        return this.minYLocal.getReadOnlyProperty();
    }

    public double getMinYLocal() {
        return this.minYLocal.get();
    }

    public double getMaxXLocal() {
        return this.getWidth();
    }

    public double getMaxYLocal() {
        return this.getHeight();
    }

    public ReadOnlyDoubleProperty minXWorldProperty() {
        return this.minXWorld.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty minYWorldProperty() {
        return this.minYWorld.getReadOnlyProperty();
    }

    public ReadOnlyDoubleProperty maxXWorldProperty() {
        return this.maxXWorld.getReadOnlyProperty();
    }

    public double getMinXWorld() {
        return this.getPositionX() + this.getMinXLocal();
    }

    public ReadOnlyDoubleProperty maxYWorldProperty() {
        return this.maxYWorld.getReadOnlyProperty();
    }

    public double getMinYWorld() {
        return this.getPositionY() + this.getMinYLocal();
    }

    public double getMaxXWorld() {
        return this.getPositionX() + this.getMinXLocal() + this.getWidth();
    }

    public double getMaxYWorld() {
        return this.getPositionY() + this.getMinYLocal() + this.getHeight();
    }

    public Point2D getCenterLocal() {
        return new Point2D(this.getWidth() / 2.0, this.getHeight() / 2.0);
    }

    public Point2D getCenterWorld() {
        return this.getCenterLocal().add(this.getMinXWorld(), this.getMinYWorld());
    }

    private double computeMinXLocal() {
        return this.hitBoxes.stream().mapToDouble(HitBox::getMinX).min().orElse(0.0);
    }

    private double computeMinYLocal() {
        return this.hitBoxes.stream().mapToDouble(HitBox::getMinY).min().orElse(0.0);
    }

    private double getPositionX() {
        return this.position.getX();
    }

    private double getPositionY() {
        return this.position.getY();
    }

    private boolean checkCollision(HitBox box1, HitBox box2) {
        return box2.getMaxXWorld() >= box1.getMinXWorld() && box2.getMaxYWorld() >= box1.getMinYWorld() && box2.getMinXWorld() <= box1.getMaxXWorld() && box2.getMinYWorld() <= box1.getMaxYWorld();
    }

    private boolean checkCollision(HitBox box1, HitBox box2, double angle1, double angle2) {
        return SAT.isColliding(box1, box2, angle1, angle2);
    }

    public final CollisionResult checkCollision(BoundingBoxComponent other) {
        boolean checkRotation = this.getEntity().hasComponent(RotationComponent.class) && other.getEntity().hasComponent(RotationComponent.class);
        for (int i = 0; i < this.hitBoxes.size(); ++i) {
            HitBox box1 = (HitBox)this.hitBoxes.get(i);
            for (int j = 0; j < other.hitBoxes.size(); ++j) {
                boolean collision;
                HitBox box2 = (HitBox)other.hitBoxes.get(j);
                if (checkRotation) {
                    double angle1 = this.getEntity().getComponent(RotationComponent.class).getValue();
                    double angle2 = other.getEntity().getComponent(RotationComponent.class).getValue();
                    collision = angle1 == 0.0 && angle2 == 0.0 ? this.checkCollision(box1, box2) : this.checkCollision(box1, box2, angle1, angle2);
                } else {
                    collision = this.checkCollision(box1, box2);
                }
                if (!collision) continue;
                CollisionResult result = pooler.get(CollisionResult.class);
                result.init(box1, box2);
                return result;
            }
        }
        return CollisionResult.NO_COLLISION;
    }

    private CollisionResult checkCollisionInternal(BoundingBoxComponent other) {
        boolean checkRotation = this.getEntity().hasComponent(RotationComponent.class) && other.getEntity().hasComponent(RotationComponent.class);
        for (int i = 0; i < this.hitBoxes.size(); ++i) {
            HitBox box1 = (HitBox)this.hitBoxes.get(i);
            for (int j = 0; j < other.hitBoxes.size(); ++j) {
                boolean collision;
                HitBox box2 = (HitBox)other.hitBoxes.get(j);
                if (checkRotation) {
                    double angle1 = this.getEntity().getComponent(RotationComponent.class).getValue();
                    double angle2 = other.getEntity().getComponent(RotationComponent.class).getValue();
                    collision = angle1 == 0.0 && angle2 == 0.0 ? this.checkCollision(box1, box2) : this.checkCollision(box1, box2, angle1, angle2);
                } else {
                    collision = this.checkCollision(box1, box2);
                }
                if (!collision) continue;
                return CollisionResult.COLLISION;
            }
        }
        return CollisionResult.NO_COLLISION;
    }

    public final boolean isCollidingWith(BoundingBoxComponent other) {
        return this.checkCollisionInternal(other) != CollisionResult.NO_COLLISION;
    }

    public final boolean isWithin(Rectangle2D bounds) {
        return this.isWithin(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public final boolean isWithin(double minX, double minY, double maxX, double maxY) {
        return !this.isOutside(minX, minY, maxX, maxY);
    }

    public final boolean isOutside(Rectangle2D bounds) {
        return this.isOutside(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public final boolean isOutside(double minX, double minY, double maxX, double maxY) {
        return this.getPositionX() + this.getMinXLocal() + this.getWidth() < minX || this.getPositionX() + this.getMinXLocal() > maxX || this.getPositionY() + this.getMinYLocal() + this.getHeight() < minY || this.getPositionY() + this.getMinYLocal() > maxY;
    }

    public final Rectangle2D range(double width, double height) {
        double minX = this.getPositionX() - width;
        double minY = this.getPositionY() - height;
        double maxX = this.getMaxXWorld() + width;
        double maxY = this.getMaxYWorld() + height;
        return new Rectangle2D(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public void write(@NotNull Bundle bundle) {
        bundle.put("hitBoxes", new ArrayList<HitBox>((Collection<HitBox>)this.hitBoxes));
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        this.hitBoxes.addAll((Collection)bundle.get("hitBoxes"));
    }

    @Override
    public BoundingBoxComponent copy() {
        return new BoundingBoxComponent((HitBox[])this.hitBoxes.toArray((Object[])new HitBox[0]));
    }

    static {
        pooler.registerPool(CollisionResult.class, new Pool<CollisionResult>(){

            @Override
            protected CollisionResult newObject() {
                return new CollisionResult();
            }
        });
    }
}

