/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.io;

import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.IOTask;
import com.almasb.fxgl.io.IOTaskKt;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/almasb/fxgl/io/FS;", "", "()V", "Companion", "fxgl"})
public final class FS {
    private static final Logger log;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        log = LogManager.getLogger(FS.class);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<Void> writeDataTask(@NotNull Serializable data, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Companion.writeDataTask(data, fileName);
    }

    @JvmStatic
    @NotNull
    public static final <T> IOTask<T> readDataTask(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Companion.readDataTask(fileName);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        return Companion.loadFileNamesTask(dirName, recursive);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        Intrinsics.checkParameterIsNotNull(extensions, (String)"extensions");
        return Companion.loadFileNamesTask(dirName, recursive, extensions);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<List<String>> loadDirectoryNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        return Companion.loadDirectoryNamesTask(dirName, recursive);
    }

    @JvmStatic
    @NotNull
    public static final <T> IOTask<T> loadLastModifiedFileTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        return Companion.loadLastModifiedFileTask(dirName, recursive);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<Void> deleteFileTask(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Companion.deleteFileTask(fileName);
    }

    @JvmStatic
    @NotNull
    public static final IOTask<Void> deleteDirectoryTask(@NotNull String dirName) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        return Companion.deleteDirectoryTask(dirName);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JB\u0010\u0013\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f\u0018\u00010\u00150\u00140\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007JB\u0010\u0018\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f\u0018\u00010\u00150\u00140\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007JP\u0010\u0018\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f\u0018\u00010\u00150\u00140\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0007J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\t\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\t\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000e\u001a\u00020\fH\u0007J \u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\fH\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/io/FS$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/logging/log4j/Logger;", "deleteDirectoryTask", "Lcom/almasb/fxgl/io/IOTask;", "Ljava/lang/Void;", "dirName", "", "deleteFileTask", "fileName", "errorIfAbsent", "", "path", "Ljava/nio/file/Path;", "loadDirectoryNamesTask", "", "", "recursive", "", "loadFileNamesTask", "extensions", "Lcom/almasb/fxgl/io/FileExtension;", "loadLastModifiedFileTask", "T", "readDataTask", "writeDataTask", "data", "Ljava/io/Serializable;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private final void errorIfAbsent(Path path) {
            if (!Files.exists(path, new LinkOption[0])) {
                this.getLog().warn("Path " + path + " does not exist");
                throw (Throwable)new FileNotFoundException("Path " + path + " does not exist");
            }
        }

        @JvmStatic
        @NotNull
        public final IOTask<Void> writeDataTask(@NotNull Serializable data, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            return IOTaskKt.voidTaskOf("writeDataTask(" + fileName + ")", (Function0)new Function0<Unit>(fileName, data){
                final /* synthetic */ String $fileName;
                final /* synthetic */ Serializable $data;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Path file = Paths.get(this.$fileName, new String[0]);
                    if (file.getParent() != null && !Files.exists(file.getParent(), new LinkOption[0])) {
                        com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Creating directories to: " + file.getParent());
                        Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    }
                    Closeable closeable = new ObjectOutputStream(Files.newOutputStream(file, new OpenOption[0]));
                    boolean bl = false;
                    try {
                        ObjectOutputStream it = (ObjectOutputStream)closeable;
                        com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Writing to: " + file);
                        it.writeObject(this.$data);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception exception) {
                        bl = true;
                        try {
                            closeable.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    finally {
                        if (!bl) {
                            closeable.close();
                        }
                    }
                }
                {
                    this.$fileName = string;
                    this.$data = serializable;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final <T> IOTask<T> readDataTask(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            return IOTaskKt.taskOf("readDataTask(" + fileName + ")", (Function0)new Function0<T>(fileName){
                final /* synthetic */ String $fileName;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T invoke() {
                    Path file;
                    Path path = file = Paths.get(this.$fileName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    Closeable closeable = new ObjectInputStream(Files.newInputStream(file, new OpenOption[0]));
                    boolean bl = false;
                    try {
                        ObjectInputStream it = (ObjectInputStream)closeable;
                        com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Reading from: " + file);
                        Object object = it.readObject();
                        return (T)object;
                    }
                    catch (Exception exception) {
                        bl = true;
                        try {
                            closeable.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    finally {
                        if (!bl) {
                            closeable.close();
                        }
                    }
                }
                {
                    this.$fileName = string;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            return IOTaskKt.taskOf("loadFileNamesTask(" + dirName + ", " + recursive + ")", (Function0)new Function0<List<String>>(dirName, recursive){
                final /* synthetic */ String $dirName;
                final /* synthetic */ boolean $recursive;

                public final List<String> invoke() {
                    Path dir;
                    Path path = dir = Paths.get(this.$dirName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    return Files.walk(dir, this.$recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(loadFileNamesTask.1.INSTANCE).map((Function)new Function<T, R>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final String apply(Path it) {
                            return StringsKt.replace$default((String)((Object)this.$dir.relativize(it)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                        }
                        {
                            this.$dir = path;
                        }
                    }).collect(Collectors.<T>toList());
                }
                {
                    this.$dirName = string;
                    this.$recursive = bl;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            Intrinsics.checkParameterIsNotNull(extensions, (String)"extensions");
            return IOTaskKt.taskOf("loadFileNamesTask(" + dirName + ", " + recursive + ", " + extensions + ")", (Function0)new Function0<List<String>>(dirName, recursive, extensions){
                final /* synthetic */ String $dirName;
                final /* synthetic */ boolean $recursive;
                final /* synthetic */ List $extensions;

                public final List<String> invoke() {
                    Path dir;
                    Path path = dir = Paths.get(this.$dirName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    return Files.walk(dir, this.$recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(new Predicate<Path>(this){
                        final /* synthetic */ loadFileNamesTask.2 this$0;

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean test(Path file) {
                            void $receiver$iv$iv;
                            Iterable $receiver$iv;
                            if (!Files.isRegularFile(file, new LinkOption[0])) return false;
                            Iterable iterable = $receiver$iv = (Iterable)this.this$0.$extensions;
                            Collection destination$iv$iv = new ArrayList<E>();
                            for (T element$iv$iv : $receiver$iv$iv) {
                                FileExtension it = (FileExtension)element$iv$iv;
                                if (!StringsKt.endsWith$default((String)String.valueOf(file), (String)it.getExtension(), (boolean)false, (int)2, null)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Collection collection = (List)destination$iv$iv;
                            if (collection.isEmpty()) return false;
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }).map((Function)new Function<T, R>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final String apply(Path it) {
                            return StringsKt.replace$default((String)((Object)this.$dir.relativize(it)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                        }
                        {
                            this.$dir = path;
                        }
                    }).collect(Collectors.<T>toList());
                }
                {
                    this.$dirName = string;
                    this.$recursive = bl;
                    this.$extensions = list;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final IOTask<List<String>> loadDirectoryNamesTask(@NotNull String dirName, boolean recursive) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            return IOTaskKt.taskOf("loadDirectoryNamesTask(" + dirName + ", " + recursive + ")", (Function0)new Function0<List<String>>(dirName, recursive){
                final /* synthetic */ String $dirName;
                final /* synthetic */ boolean $recursive;

                public final List<String> invoke() {
                    Path dir;
                    Path path = dir = Paths.get(this.$dirName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    return Files.walk(dir, this.$recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(loadDirectoryNamesTask.1.INSTANCE).map((Function)new Function<T, R>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final String apply(Path it) {
                            return StringsKt.replace$default((String)((Object)this.$dir.relativize(it)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                        }
                        {
                            this.$dir = path;
                        }
                    }).filter(loadDirectoryNamesTask.3.INSTANCE).collect(Collectors.<T>toList());
                }
                {
                    this.$dirName = string;
                    this.$recursive = bl;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final <T> IOTask<T> loadLastModifiedFileTask(@NotNull String dirName, boolean recursive) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            return IOTaskKt.taskOf("loadLastModifiedFileTask(" + dirName + ", " + recursive + ")", (Function0)new Function0<String>(dirName, recursive){
                final /* synthetic */ String $dirName;
                final /* synthetic */ boolean $recursive;

                public final String invoke() {
                    Path dir;
                    Path path = dir = Paths.get(this.$dirName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    return (String)Files.walk(dir, this.$recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(loadLastModifiedFileTask.1.INSTANCE).sorted(loadLastModifiedFileTask.2.INSTANCE).findFirst().map((Function)new Function<T, U>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final String apply(Path it) {
                            return StringsKt.replace$default((String)((Object)this.$dir.relativize(it)).toString(), (String)"\\", (String)"/", (boolean)false, (int)4, null);
                        }
                        {
                            this.$dir = path;
                        }
                    }).orElseThrow(new Supplier<X>(dir){
                        final /* synthetic */ Path $dir;

                        @NotNull
                        public final FileNotFoundException get() {
                            return new FileNotFoundException("No files found in " + this.$dir);
                        }
                        {
                            this.$dir = path;
                        }
                    });
                }
                {
                    this.$dirName = string;
                    this.$recursive = bl;
                    super(0);
                }
            }).then((Function1)new Function1<String, IOTask<T>>(dirName){
                final /* synthetic */ String $dirName;

                @NotNull
                public final IOTask<T> invoke(String fileName) {
                    return FS.Companion.readDataTask(this.$dirName + fileName);
                }
                {
                    this.$dirName = string;
                    super(1);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final IOTask<Void> deleteFileTask(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            return IOTaskKt.voidTaskOf("deleteFileTask(" + fileName + ")", (Function0)new Function0<Unit>(fileName){
                final /* synthetic */ String $fileName;

                public final void invoke() {
                    Path file;
                    Path path = file = Paths.get(this.$fileName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Deleting file: " + file);
                    Files.delete(file);
                }
                {
                    this.$fileName = string;
                    super(0);
                }
            });
        }

        @JvmStatic
        @NotNull
        public final IOTask<Void> deleteDirectoryTask(@NotNull String dirName) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            return IOTaskKt.voidTaskOf("deleteDirectoryTask(" + dirName + ")", (Function0)new Function0<Path>(dirName){
                final /* synthetic */ String $dirName;

                public final Path invoke() {
                    Path dir;
                    Path path = dir = Paths.get(this.$dirName, new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                    com.almasb.fxgl.io.FS$Companion.access$errorIfAbsent(FS.Companion, path);
                    return Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @NotNull
                        public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes p1) {
                            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Deleting file: " + file);
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @NotNull
                        public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException e) {
                            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                            if (e == null) {
                                com.almasb.fxgl.io.FS$Companion.access$getLog$p(FS.Companion).debug("Deleting directory: " + dir);
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw (Throwable)e;
                        }
                    });
                }
                {
                    this.$dirName = string;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        public static final /* synthetic */ Logger access$getLog$p(Companion $this) {
            return $this.getLog();
        }

        public static final /* synthetic */ void access$errorIfAbsent(Companion $this, @NotNull Path path) {
            $this.errorIfAbsent(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

