/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Viewport;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

public abstract class FXGLScene {
    private Pane root;
    private Pane contentRoot;
    private Viewport viewport;
    private BooleanProperty active = new SimpleBooleanProperty(false);

    public FXGLScene() {
        this.root = new Pane();
        this.root.setBackground(null);
        this.contentRoot = new Pane();
        this.contentRoot.setBackground(null);
        this.root.getChildren().addAll((Object[])new Node[]{this.contentRoot});
        this.viewport = new Viewport(FXGL.getAppWidth(), FXGL.getAppHeight());
        this.setCursor("fxgl_default.png", new Point2D(7.0, 6.0));
    }

    public final Pane getRoot() {
        return this.root;
    }

    public final Pane getContentRoot() {
        return this.contentRoot;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public final double getWidth() {
        return this.root.getPrefWidth();
    }

    public final double getHeight() {
        return this.root.getPrefHeight();
    }

    public final void setEffect(Effect effect) {
        this.contentRoot.setEffect(effect);
    }

    public final Effect getEffect() {
        return this.contentRoot.getEffect();
    }

    public final void clearEffect() {
        this.setEffect(null);
    }

    public final void setCursor(String imageName, Point2D hotspot) {
        this.root.setCursor((Cursor)new ImageCursor(FXGL.getAssetLoader().loadCursorImage(imageName), hotspot.getX(), hotspot.getY()));
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public void appendCSS(CSS css) {
        this.getRoot().getStylesheets().add((Object)css.getExternalForm());
    }

    public void clearCSS() {
        this.getRoot().getStylesheets().clear();
    }

    public void bindSize(DoubleProperty scaledWidth, DoubleProperty scaledHeight, DoubleProperty scaleRatio) {
        this.root.prefWidthProperty().bind((ObservableValue)scaledWidth);
        this.root.prefHeightProperty().bind((ObservableValue)scaledHeight);
        Scale scale = new Scale();
        scale.xProperty().bind((ObservableValue)scaleRatio);
        scale.yProperty().bind((ObservableValue)scaleRatio);
        this.root.getTransforms().setAll((Object[])new Transform[]{scale});
    }
}

