/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.listener.UpdateListener;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.gameplay.NotificationEvent;
import com.almasb.fxgl.gameplay.NotificationListener;
import com.almasb.fxgl.saving.UserProfileSavable;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;

public interface AudioPlayer
extends UserProfileSavable,
UpdateListener,
NotificationListener {
    @Override
    default public void onNotificationEvent(NotificationEvent event) {
        this.playSound(FXGLAssets.SOUND_NOTIFICATION);
    }

    public DoubleProperty globalMusicVolumeProperty();

    default public double getGlobalMusicVolume() {
        return this.globalMusicVolumeProperty().get();
    }

    default public void setGlobalMusicVolume(double volume) {
        this.globalMusicVolumeProperty().set(volume);
    }

    public DoubleProperty globalSoundVolumeProperty();

    default public double getGlobalSoundVolume() {
        return this.globalSoundVolumeProperty().get();
    }

    default public void setGlobalSoundVolume(double volume) {
        this.globalSoundVolumeProperty().set(volume);
    }

    default public void playSound(String assetName) {
        this.playSound(FXGL.getAssetLoader().loadSound(assetName));
    }

    default public void playPositionalSound(String assetName, Point2D soundPosition, Point2D earPosition, double maxDistance) {
        this.playPositionalSound(FXGL.getAssetLoader().loadSound(assetName), soundPosition, earPosition, maxDistance);
    }

    public void playPositionalSound(Sound var1, Point2D var2, Point2D var3, double var4);

    default public void playMusic(String assetName) {
        this.playMusic(FXGL.getAssetLoader().loadMusic(assetName));
    }

    public void playSound(Sound var1);

    public void stopSound(Sound var1);

    public void stopAllSounds();

    public void playMusic(Music var1);

    public void pauseMusic(Music var1);

    public void resumeMusic(Music var1);

    public void stopMusic(Music var1);

    public void pauseAllMusic();

    public void resumeAllMusic();

    public void stopAllMusic();
}

