/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service;

import com.almasb.fxgl.util.EmptyRunnable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.property.DoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;

public interface DialogFactory {
    public Pane messageDialog(String var1, Runnable var2);

    default public Pane messageDialog(String message) {
        return this.messageDialog(message, EmptyRunnable.INSTANCE);
    }

    public Pane confirmationDialog(String var1, Consumer<Boolean> var2);

    default public Pane inputDialog(String message, Consumer<String> callback) {
        return this.inputDialog(message, s -> true, callback);
    }

    public Pane inputDialog(String var1, Predicate<String> var2, Consumer<String> var3);

    public Pane inputDialogWithCancel(String var1, Predicate<String> var2, Consumer<String> var3);

    public Pane errorDialog(Throwable var1, Runnable var2);

    default public Pane errorDialog(Throwable error) {
        return this.errorDialog(error, (Runnable)EmptyRunnable.INSTANCE);
    }

    default public Pane errorDialog(String errorMessage) {
        return this.errorDialog(errorMessage, (Runnable)EmptyRunnable.INSTANCE);
    }

    default public Pane errorDialog(String errorMessage, Runnable callback) {
        return this.messageDialog("Error occurred: " + errorMessage, callback);
    }

    public Pane progressDialog(DoubleProperty var1, Runnable var2);

    public Pane progressDialogIndeterminate(String var1, Runnable var2);

    @Deprecated
    public Pane customDialog(String var1, Node var2, Runnable var3, Button ... var4);

    public Pane customDialog(Node var1, Runnable var2);
}

