/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.animation;

import com.almasb.fxgl.entity.GameEntity;
import com.almasb.fxgl.entity.animation.ColorAnimationBuilder;
import com.almasb.fxgl.entity.animation.RotationAnimationBuilder;
import com.almasb.fxgl.entity.animation.ScaleAnimationBuilder;
import com.almasb.fxgl.entity.animation.TranslationAnimationBuilder;
import com.almasb.fxgl.entity.component.ColorComponent;
import com.almasb.fxgl.util.EmptyRunnable;
import java.util.Arrays;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.util.Duration;

public final class AnimationBuilder {
    private Duration duration = Duration.seconds((double)1.0);
    private Duration delay = Duration.ZERO;
    private Interpolator interpolator = Interpolator.LINEAR;
    private int times = 1;
    private Runnable onFinished = EmptyRunnable.INSTANCE;
    private boolean autoReverse = false;
    private List<GameEntity> entities;

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public int getTimes() {
        return this.times;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public Runnable getOnFinished() {
        return this.onFinished;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    List<GameEntity> getEntities() {
        return this.entities;
    }

    public AnimationBuilder duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public AnimationBuilder delay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public AnimationBuilder repeat(int times) {
        this.times = times;
        return this;
    }

    public AnimationBuilder onFinished(Runnable onFinished) {
        this.onFinished = onFinished;
        return this;
    }

    public AnimationBuilder interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public AnimationBuilder autoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
        return this;
    }

    public RotationAnimationBuilder rotate(GameEntity ... entities) {
        return this.rotate(Arrays.asList(entities));
    }

    public RotationAnimationBuilder rotate(List<GameEntity> entities) {
        this.entities = entities;
        return new RotationAnimationBuilder(this);
    }

    public TranslationAnimationBuilder translate(GameEntity ... entities) {
        return this.translate(Arrays.asList(entities));
    }

    public TranslationAnimationBuilder translate(List<GameEntity> entities) {
        this.entities = entities;
        return new TranslationAnimationBuilder(this);
    }

    public ScaleAnimationBuilder scale(GameEntity ... entities) {
        return this.scale(Arrays.asList(entities));
    }

    public ScaleAnimationBuilder scale(List<GameEntity> entities) {
        this.entities = entities;
        return new ScaleAnimationBuilder(this);
    }

    public ColorAnimationBuilder color(GameEntity ... entities) {
        return this.color(Arrays.asList(entities));
    }

    public ColorAnimationBuilder color(List<GameEntity> entities) {
        this.entities = entities;
        boolean dontHaveColor = this.entities.stream().anyMatch(e -> !e.hasComponent(ColorComponent.class));
        if (dontHaveColor) {
            throw new IllegalArgumentException("All entities must have ColorComponent");
        }
        return new ColorAnimationBuilder(this);
    }
}

