/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay.cutscene;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.logging.FXGLLogger;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.cutscene.CutsceneState;
import com.almasb.fxgl.gameplay.cutscene.JRPGCutscene;
import com.almasb.fxgl.gameplay.cutscene.JRPGCutsceneState;
import com.almasb.fxgl.gameplay.cutscene.RPGCutscene;
import com.almasb.fxgl.gameplay.cutscene.RPGCutsceneState;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/gameplay/cutscene/CutsceneManager;", "", "()V", "cachedScripts", "Ljava/util/HashMap;", "", "Lcom/almasb/fxgl/gameplay/cutscene/RPGCutscene;", "Lkotlin/collections/HashMap;", "jrpgState", "Lcom/almasb/fxgl/gameplay/cutscene/JRPGCutsceneState;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "rpgState", "Lcom/almasb/fxgl/gameplay/cutscene/RPGCutsceneState;", "startCutscene", "", "scriptName", "startJRPG", "cutscene", "Lcom/almasb/fxgl/gameplay/cutscene/JRPGCutscene;", "startRPG", "fxgl"})
public final class CutsceneManager {
    private final Logger log = FXGLLogger.Companion.get(this.getClass());
    private final HashMap<String, RPGCutscene> cachedScripts;
    private final RPGCutsceneState rpgState;
    private final JRPGCutsceneState jrpgState;

    public final void startCutscene(@NotNull String scriptName) {
        Intrinsics.checkParameterIsNotNull((Object)scriptName, (String)"scriptName");
        if (FXGL.Companion.getApp().getStateMachine().getCurrentState() instanceof CutsceneState) {
            this.log.warning("Cannot start more than 1 cutscene");
            return;
        }
        if (StringsKt.endsWith$default((String)scriptName, (String)".js", (boolean)false, (int)2, null)) {
            RPGCutscene rPGCutscene = this.cachedScripts.get(scriptName);
            if (rPGCutscene == null) {
                rPGCutscene = new RPGCutscene(scriptName);
            }
            this.startRPG(rPGCutscene);
        } else if (StringsKt.endsWith$default((String)scriptName, (String)".txt", (boolean)false, (int)2, null)) {
            this.startJRPG(new JRPGCutscene(scriptName));
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported cutscene format");
        }
    }

    private final void startRPG(RPGCutscene cutscene) {
        Map map2 = this.cachedScripts;
        String string = cutscene.getScriptName();
        RPGCutscene rPGCutscene = cutscene;
        map2.put(string, rPGCutscene);
        this.rpgState.start$fxgl(cutscene);
        FXGL.Companion.getApp().getStateMachine().pushState(this.rpgState);
    }

    private final void startJRPG(JRPGCutscene cutscene) {
        this.jrpgState.start$fxgl(cutscene);
        FXGL.Companion.getApp().getStateMachine().pushState(this.jrpgState);
    }

    public CutsceneManager() {
        CutsceneManager cutsceneManager2 = this;
        HashMap hashMap = new HashMap();
        cutsceneManager2.cachedScripts = hashMap;
        this.rpgState = new RPGCutsceneState();
        this.jrpgState = new JRPGCutsceneState();
    }
}

