/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.EntityWorldListener;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.component.BoundingBoxComponent;
import com.almasb.fxgl.entity.component.CollidableComponent;
import com.almasb.fxgl.entity.component.PositionComponent;
import com.almasb.fxgl.entity.component.TypeComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.physics.CollisionPair;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.EdgeCallback;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.PhysicsControl;
import com.almasb.fxgl.physics.PhysicsParticleComponent;
import com.almasb.fxgl.physics.PhysicsParticleControl;
import com.almasb.fxgl.physics.RaycastResult;
import com.almasb.fxgl.physics.box2d.callbacks.ContactImpulse;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.collision.shapes.ChainShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.CircleShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.PolygonShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroup;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroupDef;
import com.almasb.fxgl.service.Pooler;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Iterator;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;

@Singleton
public final class PhysicsWorld
implements EntityWorldListener,
ContactListener {
    private static final Logger log = FXGL.getLogger("FXGL.PhysicsWorld");
    private final double PIXELS_PER_METER;
    private final double METERS_PER_PIXELS;
    private World jboxWorld = new World(new Vec2(0.0f, -10.0f));
    private Array<Entity> entities = new UnorderedArray<Entity>(128);
    private Array<CollisionHandler> collisionHandlers = new UnorderedArray<CollisionHandler>(16);
    private Array<CollisionPair> collisions = new UnorderedArray<CollisionPair>(128);
    private int appHeight;
    private Pooler pooler = FXGL.getPooler();
    private Array<Entity> delayedBodiesAdd = new UnorderedArray<Entity>();
    private Array<Entity> delayedParticlesAdd = new UnorderedArray<Entity>();
    private Array<Body> delayedBodiesRemove = new UnorderedArray<Body>();
    private Array<Entity> collidables = new UnorderedArray<Entity>(128);
    private EdgeCallback raycastCallback = new EdgeCallback();

    public World getJBox2DWorld() {
        return this.jboxWorld;
    }

    public int getAppHeight() {
        return this.appHeight;
    }

    private boolean isCollidable(Entity e) {
        if (!e.isActive()) {
            return false;
        }
        CollidableComponent collidable = e.getComponent(CollidableComponent.class);
        return collidable != null && collidable.getValue();
    }

    private boolean areCollidable(Entity e1, Entity e2) {
        return this.isCollidable(e1) && this.isCollidable(e2);
    }

    private boolean needManualCheck(Entity e1, Entity e2) {
        PhysicsComponent p1 = e1.getComponent(PhysicsComponent.class);
        if (p1 == null) {
            return true;
        }
        PhysicsComponent p2 = e2.getComponent(PhysicsComponent.class);
        if (p2 == null) {
            return true;
        }
        return p1.body.getType() == BodyType.KINEMATIC && p2.body.getType() == BodyType.STATIC || p2.body.getType() == BodyType.KINEMATIC && p1.body.getType() == BodyType.STATIC;
    }

    private CollisionHandler getHandler(Entity e1, Entity e2) {
        if (!e1.isActive() || !e2.isActive()) {
            return null;
        }
        Object type1 = e1.getComponent(TypeComponent.class).getValue();
        Object type2 = e2.getComponent(TypeComponent.class).getValue();
        for (CollisionHandler handler2 : this.collisionHandlers) {
            if (!handler2.equal(type1, type2)) continue;
            return handler2;
        }
        return null;
    }

    private CollisionPair getPair(Entity e1, Entity e2) {
        int index = this.getPairIndex(e1, e2);
        return index == -1 ? null : this.collisions.get(index);
    }

    private int getPairIndex(Entity e1, Entity e2) {
        for (int i = 0; i < this.collisions.size(); ++i) {
            CollisionPair pair = this.collisions.get(i);
            if (!pair.equal(e1, e2)) continue;
            return i;
        }
        return -1;
    }

    @Inject
    protected PhysicsWorld(@Named(value="appHeight") int appHeight, @Named(value="physics.ppm") double ppm) {
        this.appHeight = appHeight;
        this.PIXELS_PER_METER = ppm;
        this.METERS_PER_PIXELS = 1.0 / this.PIXELS_PER_METER;
        this.initCollisionPool();
        this.initContactListener();
        this.initParticles();
        log.debugf("Physics world initialized: appHeight=%d, physics.ppm=%.1f", appHeight, ppm);
    }

    private void initCollisionPool() {
        this.pooler.registerPool(CollisionPair.class, new Pool<CollisionPair>(){

            @Override
            protected CollisionPair newObject() {
                return new CollisionPair();
            }
        });
    }

    private void initContactListener() {
        this.jboxWorld.setContactListener(this);
    }

    private void initParticles() {
        this.jboxWorld.setParticleGravityScale(0.4f);
        this.jboxWorld.setParticleDensity(1.2f);
        this.jboxWorld.setParticleRadius(this.toMeters(1.0));
    }

    @Override
    public void onEntityAdded(Entity entity) {
        this.entities.add(entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityAdded(entity);
        } else if (entity.hasComponent(PhysicsParticleComponent.class)) {
            this.onPhysicsParticleEntityAdded(entity);
        }
    }

    private void onPhysicsEntityAdded(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.createBody(entity);
        } else {
            this.delayedBodiesAdd.add(entity);
        }
    }

    private void onPhysicsParticleEntityAdded(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.createPhysicsParticles(entity);
        } else {
            this.delayedParticlesAdd.add(entity);
        }
    }

    @Override
    public void onEntityRemoved(Entity entity) {
        this.entities.removeValueByIdentity(entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityRemoved(entity);
        }
    }

    private void onPhysicsEntityRemoved(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.destroyBody(entity);
        } else {
            this.delayedBodiesRemove.add(Entities.getPhysics(entity).getBody());
        }
    }

    @Override
    public void onWorldUpdate(double tpf) {
        this.jboxWorld.step((float)tpf, 8, 3);
        this.postStep();
        this.checkCollisions();
        this.notifyCollisions();
    }

    private void postStep() {
        for (Entity e : this.delayedBodiesAdd) {
            this.createBody(e);
        }
        this.delayedBodiesAdd.clear();
        for (Entity e : this.delayedParticlesAdd) {
            this.createPhysicsParticles(e);
        }
        this.delayedParticlesAdd.clear();
        for (Body body : this.delayedBodiesRemove) {
            this.jboxWorld.destroyBody(body);
        }
        this.delayedBodiesRemove.clear();
    }

    public void clear() {
        log.debug("Clearing physics world");
        this.entities.clear();
        this.collisions.clear();
    }

    public void clearCollisionHandlers() {
        this.collisionHandlers.clear();
    }

    @Override
    public void beginContact(Contact contact) {
        CollisionPair pair;
        Entity e2;
        Entity e1 = (Entity)contact.getFixtureA().getBody().getUserData();
        if (!this.areCollidable(e1, e2 = (Entity)contact.getFixtureB().getBody().getUserData())) {
            return;
        }
        CollisionHandler handler2 = this.getHandler(e1, e2);
        if (handler2 != null && (pair = this.getPair(e1, e2)) == null) {
            pair = this.pooler.get(CollisionPair.class);
            pair.init(e1, e2, handler2);
            this.collisions.add(pair);
            HitBox boxA = (HitBox)contact.getFixtureA().getUserData();
            HitBox boxB = (HitBox)contact.getFixtureB().getUserData();
            handler2.onHitBoxTrigger((Entity)pair.getA(), (Entity)pair.getB(), e1 == pair.getA() ? boxA : boxB, e2 == pair.getB() ? boxB : boxA);
            pair.collisionBegin();
        }
    }

    @Override
    public void endContact(Contact contact) {
        int pairIndex;
        Entity e2;
        Entity e1 = (Entity)contact.getFixtureA().getBody().getUserData();
        if (!this.areCollidable(e1, e2 = (Entity)contact.getFixtureB().getBody().getUserData())) {
            return;
        }
        CollisionHandler handler2 = this.getHandler(e1, e2);
        if (handler2 != null && (pairIndex = this.getPairIndex(e1, e2)) != -1) {
            CollisionPair pair = this.collisions.get(pairIndex);
            this.collisions.removeIndex(pairIndex);
            pair.collisionEnd();
            this.pooler.put(pair);
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    private void checkCollisions() {
        for (Entity e : this.entities) {
            if (!this.isCollidable(e)) continue;
            this.collidables.add(e);
        }
        for (int i = 0; i < this.collidables.size(); ++i) {
            Entity e1 = this.collidables.get(i);
            for (int j = i + 1; j < this.collidables.size(); ++j) {
                Entity e2 = this.collidables.get(j);
                CollisionHandler handler2 = this.getHandler(e1, e2);
                if (handler2 == null || !this.needManualCheck(e1, e2)) continue;
                CollisionResult result = Entities.getBBox(e1).checkCollision(Entities.getBBox(e2));
                if (result.hasCollided()) {
                    this.collisionBeginFor(handler2, e1, e2, result.getBoxA(), result.getBoxB());
                    this.pooler.put(result);
                    continue;
                }
                this.collisionEndFor(e1, e2);
            }
        }
        this.collidables.clear();
    }

    private void collisionBeginFor(CollisionHandler handler2, Entity e1, Entity e2, HitBox a, HitBox b) {
        CollisionPair pair = this.getPair(e1, e2);
        if (pair == null) {
            pair = this.pooler.get(CollisionPair.class);
            pair.init(e1, e2, handler2);
            this.collisions.add(pair);
            handler2.onHitBoxTrigger((Entity)pair.getA(), (Entity)pair.getB(), a, b);
            pair.collisionBegin();
        }
    }

    private void collisionEndFor(Entity e1, Entity e2) {
        int pairIndex = this.getPairIndex(e1, e2);
        if (pairIndex != -1) {
            CollisionPair pair = this.collisions.get(pairIndex);
            this.collisions.removeIndex(pairIndex);
            pair.collisionEnd();
            this.pooler.put(pair);
        }
    }

    private void notifyCollisions() {
        Iterator<CollisionPair> it = this.collisions.iterator();
        while (it.hasNext()) {
            CollisionPair pair = it.next();
            if (!(((Entity)pair.getA()).isActive() && ((Entity)pair.getB()).isActive() && this.isCollidable((Entity)pair.getA()) && this.isCollidable((Entity)pair.getB()))) {
                it.remove();
                this.pooler.put(pair);
                continue;
            }
            pair.collision();
        }
    }

    public void addCollisionHandler(CollisionHandler handler2) {
        this.collisionHandlers.add(handler2);
    }

    public void removeCollisionHandler(CollisionHandler handler2) {
        this.collisionHandlers.removeValueByIdentity(handler2);
    }

    public void setGravity(double x, double y) {
        this.jboxWorld.setGravity(new Vec2(x, -y));
    }

    private void createBody(Entity e) {
        BoundingBoxComponent bbox = Entities.getBBox(e);
        PhysicsComponent physics = Entities.getPhysics(e);
        double w = bbox.getWidth();
        double h = bbox.getHeight();
        if (physics.bodyDef.getPosition().x == 0.0f && physics.bodyDef.getPosition().y == 0.0f) {
            physics.bodyDef.getPosition().set(this.toMeters(bbox.getMinXWorld() + w / 2.0), this.toMeters((double)this.appHeight - (bbox.getMinYWorld() + h / 2.0)));
        }
        if (physics.bodyDef.getAngle() == 0.0f) {
            physics.bodyDef.setAngle((float)(-Math.toRadians(Entities.getRotation(e).getValue())));
        }
        physics.body = this.jboxWorld.createBody(physics.bodyDef);
        this.createFixtures(e);
        physics.body.setUserData(e);
        physics.onInitPhysics();
        e.addControl(new PhysicsControl(this.appHeight));
    }

    private void createFixtures(Entity e) {
        BoundingBoxComponent bbox = Entities.getBBox(e);
        PhysicsComponent physics = Entities.getPhysics(e);
        PositionComponent position2 = Entities.getPosition(e);
        Point2D entityCenter = bbox.getCenterWorld();
        for (HitBox box : bbox.hitBoxesProperty()) {
            Shape b2Shape;
            Bounds bounds = box.translate(position2.getX(), position2.getY());
            Point2D boundsCenterWorld = new Point2D((bounds.getMinX() + bounds.getMaxX()) / 2.0, (bounds.getMinY() + bounds.getMaxY()) / 2.0);
            Point2D boundsCenterLocal = boundsCenterWorld.subtract(entityCenter);
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            FixtureDef fd = physics.fixtureDef;
            BoundingShape boundingShape = box.getShape();
            switch (boundingShape.type) {
                case CIRCLE: {
                    CircleShape circleShape = new CircleShape();
                    circleShape.setRadius(this.toMeters(w / 2.0));
                    circleShape.m_p.set(this.toMeters(boundsCenterLocal.getX()), -this.toMeters(boundsCenterLocal.getY()));
                    b2Shape = circleShape;
                    break;
                }
                case POLYGON: {
                    PolygonShape polygonShape = new PolygonShape();
                    polygonShape.setAsBox(this.toMeters(w / 2.0), this.toMeters(h / 2.0), new Vec2(this.toMeters(boundsCenterLocal.getX()), -this.toMeters(boundsCenterLocal.getY())), 0.0f);
                    b2Shape = polygonShape;
                    break;
                }
                case CHAIN: {
                    if (physics.body.getType() != BodyType.STATIC) {
                        throw new IllegalArgumentException("BoundingShape.chain() can only be used with static objects");
                    }
                    Point2D[] points = (Point2D[])boundingShape.data;
                    Vec2[] vertices = new Vec2[points.length];
                    for (int i = 0; i < vertices.length; ++i) {
                        vertices[i] = this.toVector(points[i].subtract(boundsCenterLocal)).subLocal(this.toVector(bbox.getCenterLocal()));
                    }
                    ChainShape chainShape = new ChainShape();
                    chainShape.createLoop(vertices, vertices.length);
                    b2Shape = chainShape;
                    break;
                }
                default: {
                    log.warning("Unsupported hit box shape");
                    throw new UnsupportedOperationException("Using unsupported shape: " + (Object)((Object)boundingShape.type));
                }
            }
            fd.setShape(b2Shape);
            Fixture fixture = physics.body.createFixture(fd);
            fixture.setUserData(box);
        }
    }

    private void createPhysicsParticles(Entity e) {
        PolygonShape rectShape;
        double x = Entities.getPosition(e).getX();
        double y = Entities.getPosition(e).getY();
        double width = Entities.getBBox(e).getWidth();
        double height = Entities.getBBox(e).getHeight();
        ParticleGroupDef def = e.getComponent(PhysicsParticleComponent.class).getDefinition();
        def.setPosition(this.toMeters(x + width / 2.0), this.toMeters((double)this.appHeight - (y + height / 2.0)));
        Shape shape = null;
        BoundingBoxComponent bbox = Entities.getBBox(e);
        if (!bbox.hitBoxesProperty().isEmpty()) {
            if (((HitBox)bbox.hitBoxesProperty().get((int)0)).getShape().type == ShapeType.POLYGON) {
                rectShape = new PolygonShape();
                rectShape.setAsBox(this.toMeters(width / 2.0), this.toMeters(height / 2.0));
                shape = rectShape;
            } else if (((HitBox)bbox.hitBoxesProperty().get((int)0)).getShape().type == ShapeType.CIRCLE) {
                CircleShape circleShape = new CircleShape();
                circleShape.setRadius(this.toMeters(width / 2.0));
                shape = circleShape;
            } else {
                log.warning("Unknown hit box shape: " + (Object)((Object)((HitBox)bbox.hitBoxesProperty().get((int)0)).getShape().type));
                throw new UnsupportedOperationException();
            }
        }
        if (shape == null) {
            rectShape = new PolygonShape();
            rectShape.setAsBox(this.toMeters(width / 2.0), this.toMeters(height / 2.0));
            shape = rectShape;
        }
        def.setShape(shape);
        ParticleGroup particleGroup = this.jboxWorld.createParticleGroup(def);
        Color color = e.getComponent(PhysicsParticleComponent.class).getColor();
        e.addControl(new PhysicsParticleControl(particleGroup, color, this));
    }

    private void destroyBody(Entity e) {
        this.jboxWorld.destroyBody(Entities.getPhysics((Entity)e).body);
    }

    public RaycastResult raycast(Point2D start2, Point2D end) {
        this.raycastCallback.reset();
        this.jboxWorld.raycast(this.raycastCallback, this.toPoint(start2), this.toPoint(end));
        Entity entity = null;
        Point2D point = null;
        if (this.raycastCallback.getFixture() != null) {
            entity = (Entity)this.raycastCallback.getFixture().getBody().getUserData();
        }
        if (this.raycastCallback.getPoint() != null) {
            point = this.toPoint(this.raycastCallback.getPoint());
        }
        if (entity == null && point == null) {
            return RaycastResult.NONE;
        }
        return new RaycastResult(entity, point);
    }

    public float toMeters(double pixels) {
        return (float)(pixels * this.METERS_PER_PIXELS);
    }

    public float toPixels(double meters) {
        return (float)(meters * this.PIXELS_PER_METER);
    }

    public Vec2 toVector(Point2D v) {
        return new Vec2(this.toMeters(v.getX()), this.toMeters(-v.getY()));
    }

    public Point2D toVector(Vec2 v) {
        return new Point2D((double)this.toPixels(v.x), (double)this.toPixels(-v.y));
    }

    public Vec2 toPoint(Point2D p) {
        return new Vec2(this.toMeters(p.getX()), this.toMeters((double)this.appHeight - p.getY()));
    }

    public Point2D toPoint(Vec2 p) {
        return new Point2D((double)this.toPixels(p.x), (double)this.toPixels(this.toMeters(this.appHeight) - p.y));
    }
}

