/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.service.impl.display;

import com.almasb.fxgl.app.DialogSubState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.io.UIDialogHandler;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.service.Display;
import com.almasb.fxgl.service.impl.display.DisplayEvent;
import com.almasb.fxgl.service.impl.display.FXGLDisplay;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.settings.SceneDimension;
import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J,\u0010*\u001a&\u0012\f\u0012\n ,*\u0004\u0018\u00010\u000b0\u000b ,*\u0012\u0012\f\u0012\n ,*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010+0+H\u0016J\u0010\u0010-\u001a\n ,*\u0004\u0018\u00010.0.H\u0002J\b\u0010/\u001a\u00020(H\u0016J\u0006\u00100\u001a\u00020(J\u0006\u00101\u001a\u00020(J\u0016\u00102\u001a\u0010\u0012\f\u0012\n ,*\u0004\u0018\u00010\u001f0\u001f0\u001eH\u0016J\u0006\u00103\u001a\u00020(J\u0006\u00104\u001a\u00020(J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020%H\u0002J\b\u00107\u001a\u00020%H\u0002J\b\u00108\u001a\u00020%H\u0002J\u0010\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020\u000bH\u0016J\u0010\u0010>\u001a\u00020%2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010?\u001a\u00020@H\u0016J\u0018\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020(H\u0002J\u0010\u0010D\u001a\u00020%2\u0006\u0010=\u001a\u00020\u000bH\u0016J\u0010\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020\u001fH\u0016J1\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020N0M\"\u00020NH\u0016\u00a2\u0006\u0002\u0010OJ\u001e\u0010P\u001a\u00020%2\u0006\u0010H\u001a\u00020I2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020@0RH\u0016J\u0018\u0010S\u001a\u00020%2\u0006\u0010T\u001a\u00020I2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010S\u001a\u00020%2\u0006\u0010W\u001a\u00020XH\u0016J,\u0010Y\u001a\u00020%2\u0006\u0010H\u001a\u00020I2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020I0[2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020I0RH\u0016J,\u0010\\\u001a\u00020%2\u0006\u0010H\u001a\u00020I2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020I0[2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020I0RH\u0016J\u0018\u0010]\u001a\u00020%2\u0006\u0010H\u001a\u00020I2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010^\u001a\u00020_2\u0006\u0010H\u001a\u00020IH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u001ej\b\u0012\u0004\u0012\u00020\u000b`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/almasb/fxgl/service/impl/display/FXGLDisplay;", "Lcom/almasb/fxgl/service/Display;", "stage", "Ljavafx/stage/Stage;", "settings", "Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;", "(Ljavafx/stage/Stage;Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;)V", "css", "Lcom/almasb/fxgl/scene/CSS;", "currentScene", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "Lcom/almasb/fxgl/scene/FXGLScene;", "dialogState", "Lcom/almasb/fxgl/app/DialogSubState;", "fxScene", "Ljavafx/scene/Scene;", "genericHandler", "Ljavafx/event/EventHandler;", "Ljavafx/event/Event;", "keyHandler", "Ljavafx/scene/input/KeyEvent;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "mouseHandler", "Ljavafx/scene/input/MouseEvent;", "scaleRatio", "Ljavafx/beans/property/DoubleProperty;", "scaledHeight", "scaledWidth", "sceneDimensions", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/settings/SceneDimension;", "scenes", "Lkotlin/collections/ArrayList;", "targetHeight", "targetWidth", "computeScaledSize", "", "computeSceneSettings", "width", "", "height", "currentSceneProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "kotlin.jvm.PlatformType", "getBounds", "Ljavafx/geometry/Rectangle2D;", "getScaleRatio", "getScaledHeight", "getScaledWidth", "getSceneDimensions", "getTargetHeight", "getTargetWidth", "initAndShow", "initDialogBox", "initScene", "initStage", "load", "profile", "Lcom/almasb/fxgl/saving/UserProfile;", "registerScene", "scene", "save", "saveScreenshot", "", "setNewResolution", "w", "h", "setScene", "setSceneDimension", "dimension", "showBox", "message", "", "content", "Ljavafx/scene/Node;", "buttons", "", "Ljavafx/scene/control/Button;", "(Ljava/lang/String;Ljavafx/scene/Node;[Ljavafx/scene/control/Button;)V", "showConfirmationBox", "resultCallback", "Ljava/util/function/Consumer;", "showErrorBox", "errorMessage", "callback", "Ljava/lang/Runnable;", "error", "", "showInputBox", "filter", "Ljava/util/function/Predicate;", "showInputBoxWithCancel", "showMessageBox", "showProgressBox", "Lcom/almasb/fxgl/io/UIDialogHandler;", "fxgl"})
public final class FXGLDisplay
implements Display {
    private final Logger log;
    private final ReadOnlyObjectWrapper<FXGLScene> currentScene;
    private final DoubleProperty targetWidth;
    private final DoubleProperty targetHeight;
    private final DoubleProperty scaledWidth;
    private final DoubleProperty scaledHeight;
    private final DoubleProperty scaleRatio;
    private final CSS css;
    private final ArrayList<SceneDimension> sceneDimensions;
    private Scene fxScene;
    private final EventHandler<KeyEvent> keyHandler;
    private final EventHandler<MouseEvent> mouseHandler;
    private final EventHandler<Event> genericHandler;
    private final ArrayList<FXGLScene> scenes;
    private DialogSubState dialogState;
    private final Stage stage;
    private final ReadOnlyGameSettings settings;

    @Override
    public void initAndShow() {
        this.initScene();
        this.initStage();
        this.initDialogBox();
        this.computeSceneSettings(this.settings.getWidth(), this.settings.getHeight());
        this.computeScaledSize();
        this.log.debug("Opening primary stage");
        this.stage.show();
    }

    private final void initScene() {
        Parent parent = (Parent)new Pane();
        Double d = this.targetWidth.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"targetWidth.value");
        double d2 = d;
        Double d3 = this.targetHeight.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"targetHeight.value");
        Scene scene = this.fxScene = new Scene(parent, d2, d3.doubleValue());
        if (scene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene.addEventHandler(KeyEvent.ANY, this.keyHandler);
        Scene scene2 = this.fxScene;
        if (scene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene2.addEventHandler(MouseEvent.ANY, this.mouseHandler);
        Scene scene3 = this.fxScene;
        if (scene3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene3.addEventHandler(EventType.ROOT, this.genericHandler);
    }

    private final void initStage() {
        Stage stage;
        Stage $receiver = stage = this.stage;
        Scene scene = this.fxScene;
        if (scene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        $receiver.setScene(scene);
        $receiver.setTitle(this.settings.getTitle() + " " + this.settings.getVersion());
        $receiver.setResizable(false);
        $receiver.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ FXGLDisplay this$0;
            {
                this.this$0 = fXGLDisplay;
            }

            public final void handle(WindowEvent e) {
                e.consume();
                if (FXGLDisplay.access$getSettings$p(this.this$0).isCloseConfirmation()) {
                    if (FXGL.Companion.getApp().getStateMachine().canShowCloseDialog()) {
                        this.this$0.showConfirmationBox("Exit the game?", initStage.1.1.INSTANCE);
                    }
                } else {
                    FXGL.Companion.getEventBus().fireEvent(new DisplayEvent(DisplayEvent.CLOSE_REQUEST));
                }
            }
        });
        $receiver.setOnShown((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ FXGLDisplay this$0;
            {
                this.this$0 = fXGLDisplay;
            }

            public final void handle(WindowEvent it) {
                FXGLDisplay.access$getLog$p(this.this$0).debug("Stage shown");
                FXGLDisplay.access$getLog$p(this.this$0).debug("Root size: " + FXGLDisplay.access$getStage$p(this.this$0).getScene().getRoot().getLayoutBounds().getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getScene().getRoot().getLayoutBounds().getHeight());
                FXGLDisplay.access$getLog$p(this.this$0).debug("Scene size: " + FXGLDisplay.access$getStage$p(this.this$0).getScene().getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getScene().getHeight());
                FXGLDisplay.access$getLog$p(this.this$0).debug("Stage size: " + FXGLDisplay.access$getStage$p(this.this$0).getWidth() + "x" + FXGLDisplay.access$getStage$p(this.this$0).getHeight());
            }
        });
        $receiver.getIcons().add((Object)FXGLAssets.UI_ICON);
        if (this.settings.isFullScreen()) {
            $receiver.setFullScreenExitHint("");
            $receiver.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            $receiver.setFullScreen(true);
        }
        $receiver.sizeToScene();
        $receiver.centerOnScreen();
    }

    @Override
    public void registerScene(@NotNull FXGLScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        scene.bindSize(this.scaledWidth, this.scaledHeight, this.scaleRatio);
        scene.appendCSS(this.css);
        this.scenes.add(scene);
    }

    @Override
    public void setScene(@NotNull FXGLScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        if (!this.scenes.contains(scene)) {
            this.registerScene(scene);
        }
        this.getCurrentScene().activeProperty().set(false);
        this.currentScene.set((Object)scene);
        scene.activeProperty().set(true);
        Scene scene2 = this.fxScene;
        if (scene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene2.setRoot((Parent)scene.getRoot());
    }

    @Override
    public ReadOnlyObjectProperty<FXGLScene> currentSceneProperty() {
        return this.currentScene.getReadOnlyProperty();
    }

    private final Rectangle2D getBounds() {
        return this.settings.isFullScreen() ? Screen.getPrimary().getBounds() : Screen.getPrimary().getVisualBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveScreenshot() {
        Scene scene = this.fxScene;
        if (scene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        WritableImage fxImage = scene.snapshot(null);
        String fileName = "./" + this.settings.getTitle() + this.settings.getVersion() + LocalDateTime.now();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        BufferedImage img = SwingFXUtils.fromFXImage((Image)((Image)fxImage), null);
        try {
            Closeable closeable = Files.newOutputStream(Paths.get(fileName + ".png", new String[0]), new OpenOption[0]);
            boolean bl = false;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = ImageIO.write((RenderedImage)img, "png", it);
                return bl2;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot() failed: " + e);
            return false;
        }
    }

    @NotNull
    public ArrayList<SceneDimension> getSceneDimensions() {
        return new ArrayList<SceneDimension>((Collection)this.sceneDimensions);
    }

    private final void computeSceneSettings(double width, double height) {
        int it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Rectangle2D bounds = this.getBounds();
        double ratio = width / height;
        int[] nArray = new int[]{360, 480, 720, 1080};
        ArrayList<SceneDimension> arrayList = this.sceneDimensions;
        void var9_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            it = element$iv$iv;
            if (!((double)it <= bounds.getHeight() && (double)it * ratio <= bounds.getWidth())) continue;
            destination$iv$iv.add((int)element$iv$iv);
        }
        Collection<SceneDimension> collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            SceneDimension sceneDimension = new SceneDimension((double)it * ratio, it);
            collection.add(sceneDimension);
        }
        collection = (List)destination$iv$iv;
        arrayList.addAll(collection);
    }

    public final double getTargetWidth() {
        return this.targetWidth.get();
    }

    public final double getTargetHeight() {
        return this.targetHeight.get();
    }

    public final double getScaledWidth() {
        return this.scaledWidth.get();
    }

    public final double getScaledHeight() {
        return this.scaledHeight.get();
    }

    @Override
    public double getScaleRatio() {
        return this.scaleRatio.get();
    }

    /*
     * WARNING - void declaration
     */
    private final void computeScaledSize() {
        double newW = this.getTargetWidth();
        double newH = this.getTargetHeight();
        Rectangle2D bounds = this.getBounds();
        if (newW > bounds.getWidth() || newH > bounds.getHeight()) {
            this.log.debug("App size > screen size");
            double ratio = newW / newH;
            int n = (int)bounds.getWidth();
            int n2 = 1;
            if (n >= n2) {
                while (true) {
                    void newWidth;
                    if ((double)newWidth / ratio <= bounds.getHeight()) {
                        newW = (double)newWidth;
                        newH = (double)newWidth / ratio;
                        break;
                    }
                    if (newWidth == n2) break;
                    --newWidth;
                }
            }
        }
        this.scaledWidth.set(newW);
        this.scaledHeight.set(newH);
        this.scaleRatio.set(newW / (double)this.settings.getWidth());
        this.log.debug("Target size: " + this.targetWidth + " x " + this.targetHeight + " @ 1.0");
        this.log.debug("New size:    " + newW + " x " + newH + " @ " + this.scaleRatio);
    }

    private final void setNewResolution(double w, double h) {
        this.targetWidth.set(w);
        this.targetHeight.set(h);
        this.computeScaledSize();
        Scene scene = this.fxScene;
        if (scene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        Parent root = scene.getRoot();
        Scene scene2 = this.fxScene;
        if (scene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene2.removeEventHandler(KeyEvent.ANY, this.keyHandler);
        Scene scene3 = this.fxScene;
        if (scene3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene3.removeEventHandler(MouseEvent.ANY, this.mouseHandler);
        Scene scene4 = this.fxScene;
        if (scene4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene4.removeEventHandler(EventType.ROOT, this.genericHandler);
        Scene scene5 = this.fxScene;
        if (scene5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene5.setRoot((Parent)new Pane());
        Scene scene6 = this.fxScene = new Scene(root);
        if (scene6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene6.addEventHandler(KeyEvent.ANY, this.keyHandler);
        Scene scene7 = this.fxScene;
        if (scene7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene7.addEventHandler(MouseEvent.ANY, this.mouseHandler);
        Scene scene8 = this.fxScene;
        if (scene8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        scene8.addEventHandler(EventType.ROOT, this.genericHandler);
        Scene scene9 = this.fxScene;
        if (scene9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fxScene");
        }
        this.stage.setScene(scene9);
        if (this.settings.isFullScreen()) {
            this.stage.setFullScreen(true);
        }
    }

    @Override
    public void setSceneDimension(@NotNull SceneDimension dimension) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dimension), (String)"dimension");
        if (this.sceneDimensions.contains((Object)dimension)) {
            this.log.debug(new Supplier<String>(dimension){
                final /* synthetic */ SceneDimension $dimension;

                @NotNull
                public final String get() {
                    return "Setting scene dimension: " + (Object)((Object)this.$dimension);
                }
                {
                    this.$dimension = sceneDimension;
                }
            });
            this.setNewResolution(dimension.getWidth(), dimension.getHeight());
        } else {
            this.log.warning(new Supplier<String>(dimension){
                final /* synthetic */ SceneDimension $dimension;

                @NotNull
                public final String get() {
                    return (Object)((Object)this.$dimension) + " is not supported!";
                }
                {
                    this.$dimension = sceneDimension;
                }
            });
        }
    }

    private final void initDialogBox() {
        this.dialogState = DialogSubState.INSTANCE;
    }

    @Override
    public void showMessageBox(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showMessageBox$fxgl(message, callback);
    }

    @Override
    public void showConfirmationBox(@NotNull String message, @NotNull Consumer<Boolean> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showConfirmationBox$fxgl(message, resultCallback);
    }

    @Override
    public void showInputBox(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showInputBox$fxgl(message, filter, resultCallback);
    }

    @Override
    public void showInputBoxWithCancel(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showInputBoxWithCancel$fxgl(message, filter, resultCallback);
    }

    @Override
    public void showErrorBox(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showErrorBox$fxgl(error);
    }

    @Override
    public void showErrorBox(@NotNull String errorMessage, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showErrorBox$fxgl(errorMessage, callback);
    }

    @Override
    public void showBox(@NotNull String message, @NotNull Node content, Button ... buttons) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)buttons, (String)"buttons");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        dialogSubState.showBox$fxgl(message, content, Arrays.copyOf(buttons, buttons.length));
    }

    @Override
    @NotNull
    public UIDialogHandler showProgressBox(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        DialogSubState dialogSubState = this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        return dialogSubState.showProgressBox$fxgl(message);
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("scene");
        bundle.put("sizeW", Double.valueOf(this.getTargetWidth()));
        bundle.put("sizeH", Double.valueOf(this.getTargetHeight()));
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("scene");
        bundle.log();
        this.setNewResolution(((Number)bundle.get("sizeW")).doubleValue(), ((Number)bundle.get("sizeH")).doubleValue());
    }

    @Inject
    private FXGLDisplay(Stage stage, ReadOnlyGameSettings settings) {
        this.stage = stage;
        this.settings = settings;
        this.log = FXGL.Companion.getLogger(this.getClass());
        this.currentScene = new ReadOnlyObjectWrapper((Object)new FXGLScene(){});
        this.sceneDimensions = new ArrayList();
        this.targetWidth = (DoubleProperty)new SimpleDoubleProperty((double)this.settings.getWidth());
        this.targetHeight = (DoubleProperty)new SimpleDoubleProperty((double)this.settings.getHeight());
        this.scaledWidth = (DoubleProperty)new SimpleDoubleProperty();
        this.scaledHeight = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatio = (DoubleProperty)new SimpleDoubleProperty();
        this.css = FXGLAssets.UI_CSS;
        this.log.debug("Using CSS: " + this.css);
        this.keyHandler = keyHandler.1.INSTANCE;
        this.mouseHandler = (EventHandler)new EventHandler<MouseEvent>(this){
            final /* synthetic */ FXGLDisplay this$0;

            public final void handle(MouseEvent it) {
                Input input = FXGL.Companion.getApp().getStateMachine().getCurrentState().getInput();
                MouseEvent mouseEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"it");
                Viewport viewport = this.this$0.getCurrentScene().getViewport();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewport, (String)"getCurrentScene().viewport");
                input.onMouseEvent(mouseEvent, viewport, this.this$0.getScaleRatio());
            }
            {
                this.this$0 = fXGLDisplay;
            }
        };
        this.genericHandler = genericHandler.1.INSTANCE;
        FXGLDisplay fXGLDisplay = this;
        ArrayList arrayList = new ArrayList();
        fXGLDisplay.scenes = arrayList;
    }

    @NotNull
    public static final /* synthetic */ ReadOnlyGameSettings access$getSettings$p(FXGLDisplay $this) {
        return $this.settings;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$p(FXGLDisplay $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ Stage access$getStage$p(FXGLDisplay $this) {
        return $this.stage;
    }
}

