/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.algorithm;

import com.almasb.fxgl.algorithm.Grid;
import com.almasb.fxgl.algorithm.Tile;
import com.almasb.fxgl.algorithm.TileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u00120\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/algorithm/MapGenerator;", "", "()V", "seed", "", "(J)V", "ATTRACT_RANGE", "", "rand", "Ljava/util/Random;", "getSeed", "()J", "create", "Lcom/almasb/fxgl/algorithm/Grid;", "width", "height", "pairs", "", "Lkotlin/Pair;", "Lcom/almasb/fxgl/algorithm/TileType;", "fxgl"})
public final class MapGenerator {
    private final Random rand;
    private final int ATTRACT_RANGE = 25;
    private final long seed;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Grid create(int width, int height, @NotNull List<? extends Pair<? extends TileType, Integer>> pairs) {
        Object element$iv;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        Grid grid = new Grid(width, height);
        Object[] $receiver$iv = grid.getRows();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv2 = $receiver$iv[i];
            Grid.Row it = (Grid.Row)element$iv2;
            Object[] $receiver$iv2 = it.getTiles();
            for (int j = 0; j < $receiver$iv2.length; ++j) {
                element$iv = $receiver$iv2[j];
                Tile it2 = (Tile)element$iv;
                it2.setType(TileType.WATER);
            }
        }
        int count = ((Number)pairs.get(1).getSecond()).intValue();
        while (count > 0) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv3;
            int x = this.rand.nextInt(width);
            int y = this.rand.nextInt(height);
            int startX = x - this.ATTRACT_RANGE;
            int startY = y - this.ATTRACT_RANGE;
            element$iv = (Iterable)RangesKt.until((int)startX, (int)(startX + 2 * this.ATTRACT_RANGE));
            void it2 = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList();
            Iterator $i$f$forEach = $receiver$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv4;
                int element$iv$iv;
                int x1 = element$iv$iv = ((IntIterator)$i$f$forEach).nextInt();
                Iterable iterable = $receiver$iv4 = (Iterable)RangesKt.until((int)startY, (int)(startY + 2 * this.ATTRACT_RANGE));
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                Iterator iterator = $receiver$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv2;
                    Pair pair = new Pair((Object)x1, (Object)((int)it));
                    collection.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                int $receiver$iv4 = ((Number)it.getFirst()).intValue();
                if (!(0 <= $receiver$iv4 && $receiver$iv4 <= width - 1 && 0 <= ($receiver$iv4 = ((Number)it.getSecond()).intValue()) && $receiver$iv4 <= height - 1 && Intrinsics.areEqual((Object)((Object)grid.getTile(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()).getType()), (Object)((Object)TileType.EARTH)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Pair point = (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (point != null) {
                x = ((Number)point.getFirst()).intValue() + this.rand.nextInt(3) - 1;
                y = ((Number)point.getSecond()).intValue() + this.rand.nextInt(3) - 1;
                while (!grid.isValid(x, y)) {
                    x = ((Number)point.getFirst()).intValue() + this.rand.nextInt(3) - 1;
                    y = ((Number)point.getSecond()).intValue() + this.rand.nextInt(3) - 1;
                }
            }
            Tile tile = grid.getTile(x, y);
            tile.setType(TileType.EARTH);
            Iterable $receiver$iv5 = grid.getNeighbors(x, y);
            for (Object element$iv3 : $receiver$iv5) {
                Tile it = (Tile)element$iv3;
                it.setType(TileType.EARTH);
                int n = count;
                count = n + -1;
            }
            int n = count;
            count = n + -1;
        }
        return grid;
    }

    public final long getSeed() {
        return this.seed;
    }

    public MapGenerator(long seed) {
        this.seed = seed;
        this.rand = new Random(this.seed);
        this.ATTRACT_RANGE = 25;
    }

    public MapGenerator() {
        this(new Random().longs().findAny().getAsLong());
    }
}

