/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.util.EmptyRunnable;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B1\b\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\rJ\u0015\u00100\u001a\u0002012\u0006\u00102\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u001bH\u0016J\u0006\u00106\u001a\u000201J\b\u00107\u001a\u000201H\u0002J\u0006\u00108\u001a\u000201J\u000e\u00109\u001a\u0002012\u0006\u0010-\u001a\u00020.J\u0006\u0010:\u001a\u000201J\u000e\u0010;\u001a\u0002012\u0006\u0010-\u001a\u00020.J\u0006\u0010<\u001a\u000201J\u0010\u0010=\u001a\u0002012\u0006\u00105\u001a\u00020\u001bH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R$\u0010#\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u001a\u0010%\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/almasb/fxgl/animation/Animation;", "T", "Lcom/almasb/fxgl/app/listener/StateListener;", "animationBuilder", "Lcom/almasb/fxgl/entity/animation/AnimationBuilder;", "animatedValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "(Lcom/almasb/fxgl/entity/animation/AnimationBuilder;Lcom/almasb/fxgl/animation/AnimatedValue;)V", "delay", "Ljavafx/util/Duration;", "duration", "cycleCount", "", "(Ljavafx/util/Duration;Ljavafx/util/Duration;ILcom/almasb/fxgl/animation/AnimatedValue;)V", "getAnimatedValue", "()Lcom/almasb/fxgl/animation/AnimatedValue;", "checkDelay", "", "count", "getCycleCount", "()I", "setCycleCount", "(I)V", "getDelay", "()Ljavafx/util/Duration;", "getDuration", "endTime", "", "<set-?>", "isAnimating", "()Z", "setAnimating", "(Z)V", "isAutoReverse", "setAutoReverse", "isPaused", "setPaused", "isReverse", "setReverse", "onFinished", "Ljava/lang/Runnable;", "getOnFinished", "()Ljava/lang/Runnable;", "setOnFinished", "(Ljava/lang/Runnable;)V", "state", "Lcom/almasb/fxgl/app/State;", "time", "onProgress", "", "value", "(Ljava/lang/Object;)V", "onUpdate", "tpf", "pause", "resetTime", "resume", "start", "startInPlayState", "startReverse", "stop", "updateTime", "fxgl"})
public abstract class Animation<T>
implements StateListener {
    private boolean isAutoReverse;
    @NotNull
    private Runnable onFinished;
    private double time;
    private double endTime;
    private int count;
    private boolean isReverse;
    private boolean isPaused;
    private boolean isAnimating;
    private boolean checkDelay;
    private State state;
    @NotNull
    private final Duration delay;
    @NotNull
    private final Duration duration;
    private int cycleCount;
    @NotNull
    private final AnimatedValue<T> animatedValue;

    public final boolean isAutoReverse() {
        return this.isAutoReverse;
    }

    public final void setAutoReverse(boolean bl) {
        this.isAutoReverse = bl;
    }

    @NotNull
    public final Runnable getOnFinished() {
        return this.onFinished;
    }

    public final void setOnFinished(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"<set-?>");
        this.onFinished = runnable;
    }

    public final boolean isReverse() {
        return this.isReverse;
    }

    public final void setReverse(boolean bl) {
        this.isReverse = bl;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    private final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    private final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    public final void startInPlayState() {
        State state = FXGL.Companion.getApp().getStateMachine().getPlayState();
        Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"FXGL.getApp().stateMachine.playState");
        this.start(state);
    }

    public final void startReverse(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!this.isAnimating) {
            this.isReverse = true;
            this.start(state);
        }
    }

    public final void start(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!this.isAnimating) {
            this.state = state;
            this.isAnimating = true;
            state.addStateListener(this);
        }
    }

    public final void stop() {
        if (this.isAnimating) {
            this.isAnimating = false;
            State state = this.state;
            if (state == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            }
            state.removeStateListener(this);
            this.time = 0.0;
            this.count = 0;
            this.isReverse = false;
            this.checkDelay = true;
        }
    }

    public final void pause() {
        this.isPaused = true;
    }

    public final void resume() {
        this.isPaused = false;
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.isPaused) {
            return;
        }
        if (this.checkDelay) {
            this.time += tpf;
            if (this.time >= this.delay.toSeconds()) {
                this.checkDelay = false;
                this.resetTime();
            } else {
                return;
            }
        }
        if (this.isReverse && this.time == this.endTime || !this.isReverse && this.time == 0.0) {
            this.onProgress(this.animatedValue.getValue(this.isReverse ? 1.0 : 0.0));
            this.updateTime(tpf);
            return;
        }
        this.updateTime(tpf);
        if (!this.isReverse && this.time >= this.endTime || this.isReverse && this.time <= 0.0) {
            this.onProgress(this.animatedValue.getValue(this.isReverse ? 0.0 : 1.0));
            int n = this.count;
            this.count = n + 1;
            if (this.count >= this.cycleCount) {
                this.onFinished.run();
                this.stop();
            } else {
                if (this.isAutoReverse) {
                    this.isReverse = !this.isReverse;
                }
                this.resetTime();
            }
            return;
        }
        this.onProgress(this.animatedValue.getValue(this.time / this.endTime));
    }

    private final void updateTime(double tpf) {
        this.time += this.isReverse ? -tpf : tpf;
    }

    private final void resetTime() {
        this.time = this.isReverse ? this.endTime : 0.0;
    }

    public abstract void onProgress(T var1);

    @NotNull
    public final Duration getDelay() {
        return this.delay;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final int getCycleCount() {
        return this.cycleCount;
    }

    public final void setCycleCount(int n) {
        this.cycleCount = n;
    }

    @NotNull
    public final AnimatedValue<T> getAnimatedValue() {
        return this.animatedValue;
    }

    @JvmOverloads
    public Animation(@NotNull Duration delay, @NotNull Duration duration, int cycleCount, @NotNull AnimatedValue<T> animatedValue) {
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Intrinsics.checkParameterIsNotNull(animatedValue, (String)"animatedValue");
        this.delay = delay;
        this.duration = duration;
        this.cycleCount = cycleCount;
        this.animatedValue = animatedValue;
        this.onFinished = EmptyRunnable.INSTANCE;
        this.endTime = this.duration.toSeconds();
        this.checkDelay = true;
    }

    @JvmOverloads
    public /* synthetic */ Animation(Duration duration, Duration duration2, int n, AnimatedValue animatedValue, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ZERO");
            duration = duration3;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(duration, duration2, n, animatedValue);
    }

    @JvmOverloads
    public Animation(@NotNull Duration delay, @NotNull Duration duration, @NotNull AnimatedValue<T> animatedValue) {
        this(delay, duration, 0, animatedValue, 4, null);
    }

    @JvmOverloads
    public Animation(@NotNull Duration duration, @NotNull AnimatedValue<T> animatedValue) {
        this(null, duration, 0, animatedValue, 5, null);
    }

    public Animation(@NotNull AnimationBuilder animationBuilder, @NotNull AnimatedValue<T> animatedValue) {
        Intrinsics.checkParameterIsNotNull((Object)animationBuilder, (String)"animationBuilder");
        Intrinsics.checkParameterIsNotNull(animatedValue, (String)"animatedValue");
        Duration duration = animationBuilder.getDelay();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"animationBuilder.delay");
        Duration duration2 = animationBuilder.getDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"animationBuilder.duration");
        this(duration, duration2, animationBuilder.getTimes(), animatedValue);
        Runnable runnable = animationBuilder.getOnFinished();
        Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"animationBuilder.onFinished");
        this.onFinished = runnable;
        this.isAutoReverse = animationBuilder.isAutoReverse();
    }
}

