/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.service.ServiceType;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ApplicationModule
extends AbstractModule {
    private GameApplication app;
    private ReadOnlyGameSettings settings;
    List<ServiceType> allServices = new ArrayList<ServiceType>();

    ApplicationModule(GameApplication app) {
        this.app = app;
        this.settings = app.getSettings();
    }

    public GameApplication getApp() {
        return this.app;
    }

    protected final void configure() {
        this.bindApp();
        this.bindServices();
    }

    private void bindApp() {
        this.bind(GameApplication.class).toInstance((Object)this.app);
        this.bind(ReadOnlyGameSettings.class).toInstance((Object)this.settings);
        this.bind(ApplicationMode.class).toInstance((Object)this.settings.getApplicationMode());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"appWidth")).toInstance((Object)this.app.getWidth());
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"appHeight")).toInstance((Object)this.app.getHeight());
    }

    protected void bindServices() {
        this.allServices = this.mergeServices();
        for (ServiceType type : this.allServices) {
            try {
                if (type.service().equals(type.serviceProvider())) {
                    this.bind(type.serviceProvider()).in(type.scope());
                } else {
                    this.bind(type.service()).to(type.serviceProvider()).in(type.scope());
                }
                if (type.scope() != Scopes.SINGLETON) continue;
                this.bind(type.serviceProvider()).in(Scopes.SINGLETON);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to configure service: " + type.service() + " with provider: " + type.serviceProvider() + " Scope: " + type.scope() + " Error: " + e);
            }
        }
    }

    private List<ServiceType> mergeServices() {
        List userServices = this.app.getSettings().getServices().stream().map(ServiceType::service).collect(Collectors.toList());
        List<ServiceType> services = Arrays.stream(ServiceType.class.getDeclaredFields()).map(this::mapFieldToType).filter(serviceType -> !userServices.contains(serviceType.service())).collect(Collectors.toList());
        services.addAll(this.app.getSettings().getServices());
        return services;
    }

    private ServiceType mapFieldToType(Field field) {
        try {
            return (ServiceType)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to map field to service type: " + e);
        }
    }
}

