/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.devtools.Console;
import com.almasb.fxgl.devtools.controller.ColorAdjustController;
import com.almasb.fxgl.devtools.controller.DialogAddEntityController;
import com.almasb.fxgl.devtools.controller.DialogEditEntityController;
import com.almasb.fxgl.entity.component.ViewComponent;
import com.almasb.fxgl.ui.InGameWindow;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;

public class DeveloperMenuBarController
implements UIController {
    private static final Logger log = Logger.get(DeveloperMenuBarController.class);
    private GameApplication app;
    @FXML
    private Menu menuCustom;
    private UI uiColorAdjust = null;
    private EventHandler<MouseEvent> clickTracker = e -> {
        log.info("World XY: " + this.app.getInput().getMousePositionWorld() + ", UI XY: " + this.app.getInput().getMousePositionUI());
        log.info("Entities clicked: ");
        this.app.getGameWorld().getEntitiesInRange(new Rectangle2D(this.app.getInput().getMouseXWorld(), this.app.getInput().getMouseYWorld(), 1.0, 1.0)).forEach(entity -> log.info(entity.toString()));
    };
    private Console console = null;

    public Menu getCustomMenu() {
        return this.menuCustom;
    }

    @Override
    public void init() {
        this.app = FXGL.getApp();
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onExit() {
        this.app.getDisplay().showConfirmationBox("Exit?", yes -> {
            if (yes.booleanValue()) {
                this.app.exit();
            }
        });
    }

    public void openAddDialog() {
        UI ui = this.app.getAssetLoader().loadUI("dialog_add_entity.fxml", new DialogAddEntityController());
        InGameWindow window = new InGameWindow("Add Entity", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(350.0, 300.0);
        window.setContentPane(new Pane(new Node[]{ui.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void openEditDialog() {
        UI ui = this.app.getAssetLoader().loadUI("dialog_edit_entity.fxml", new DialogEditEntityController());
        InGameWindow window = new InGameWindow("Edit Entity", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(380.0, 450.0);
        window.setContentPane(new Pane(new Node[]{ui.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void openColorAdjustDialog() {
        if (this.uiColorAdjust == null) {
            this.uiColorAdjust = this.app.getAssetLoader().loadUI("dialog_color_adjust.fxml", new ColorAdjustController());
        }
        InGameWindow window = new InGameWindow("Color Adjust", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(380.0, 450.0);
        window.setContentPane(new Pane(new Node[]{this.uiColorAdjust.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void onShowBBox(ActionEvent event) {
        CheckMenuItem item = (CheckMenuItem)event.getSource();
        FXGL.setProperty("dev.showbbox", item.isSelected());
        this.app.getGameWorld().getEntitiesByComponent(ViewComponent.class).forEach(e -> e.getComponent(ViewComponent.class).turnOnDebugBBox(item.isSelected()));
    }

    public void onTrackClicks(ActionEvent event) {
        CheckMenuItem item = (CheckMenuItem)event.getSource();
        if (item.isSelected()) {
            // empty if block
        }
    }

    public void openConsole() {
        if (this.console == null) {
            this.console = new Console();
        }
        if (this.console.isOpen()) {
            this.console.close();
        } else {
            this.console.open();
        }
    }
}

