/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.annotation.AddCollisionHandler;
import com.almasb.fxgl.annotation.AnnotationParser;
import com.almasb.fxgl.annotation.SetEntityFactory;
import com.almasb.fxgl.app.AppState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.LoadingScene;
import com.almasb.fxgl.scene.SceneFactory;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/app/LoadingState;", "Lcom/almasb/fxgl/app/AppState;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "sceneFactory", "Lcom/almasb/fxgl/scene/SceneFactory;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/scene/SceneFactory;)V", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "getDataFile", "()Lcom/almasb/fxgl/saving/DataFile;", "setDataFile", "(Lcom/almasb/fxgl/saving/DataFile;)V", "loadingFinished", "", "onEnter", "", "prevState", "Lcom/almasb/fxgl/app/State;", "onUpdate", "tpf", "", "InitAppTask", "fxgl"})
public final class LoadingState
extends AppState {
    @NotNull
    private DataFile dataFile;
    private boolean loadingFinished;
    private final GameApplication app;

    @NotNull
    public final DataFile getDataFile() {
        return this.dataFile;
    }

    public final void setDataFile(@NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"<set-?>");
        this.dataFile = dataFile;
    }

    @Override
    protected void onEnter(@NotNull State prevState) {
        Intrinsics.checkParameterIsNotNull((Object)prevState, (String)"prevState");
        InitAppTask initTask = new InitAppTask(this.app, this.dataFile);
        initTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(this){
            final /* synthetic */ LoadingState this$0;

            public final void handle(WorkerStateEvent it) {
                LoadingState.access$setLoadingFinished$p(this.this$0, true);
            }
            {
                this.this$0 = loadingState;
            }
        });
        this.dataFile = DataFile.Companion.getEMPTY();
        FXGLScene fXGLScene = this.getScene();
        if (fXGLScene == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.scene.LoadingScene");
        }
        ((LoadingScene)fXGLScene).bind(initTask);
        FXGL.Companion.getExecutor().execute((Runnable)((Object)initTask));
    }

    @Override
    protected void onUpdate(double tpf) {
        if (this.loadingFinished) {
            this.app.getStateMachine().startPlay();
            this.loadingFinished = false;
        }
    }

    public LoadingState(@NotNull GameApplication app, @NotNull SceneFactory sceneFactory) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)sceneFactory, (String)"sceneFactory");
        super(sceneFactory.newLoadingScene());
        this.app = app;
        this.dataFile = DataFile.Companion.getEMPTY();
    }

    public static final /* synthetic */ boolean access$getLoadingFinished$p(LoadingState $this) {
        return $this.loadingFinished;
    }

    public static final /* synthetic */ void access$setLoadingFinished$p(LoadingState $this, boolean bl) {
        $this.loadingFinished = bl;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/app/LoadingState$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/saving/DataFile;)V", "call", "clearPreviousGame", "", "failed", "initAssets", "initComplete", "initGame", "initPhysics", "initUI", "update", "message", "", "step", "", "Companion", "fxgl"})
    private static final class InitAppTask
    extends Task<Void> {
        private final GameApplication app;
        private final DataFile dataFile;
        private static final Logger log;
        private static final AnnotationParser annotationParser;
        public static final Companion Companion;

        @Nullable
        protected Void call() {
            long start2 = System.nanoTime();
            this.clearPreviousGame();
            this.initAssets();
            this.initGame();
            this.initPhysics();
            this.initUI();
            this.initComplete();
            InitAppTask.Companion.getLog().infof("Game initialization took: %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
            return null;
        }

        private final void clearPreviousGame() {
            InitAppTask.Companion.getLog().debug("Clearing previous game");
            this.app.getGameWorld().clear();
            this.app.getPhysicsWorld().clear();
            this.app.getPhysicsWorld().clearCollisionHandlers();
            this.app.getGameScene().clear();
            this.app.getGameState().clear();
            this.app.getMasterTimer().clear();
        }

        private final void initAssets() {
            this.update("Initializing Assets", 0);
            this.app.initAssets();
        }

        private final void initGame() {
            this.update("Initializing Game", 1);
            HashMap vars = new HashMap();
            this.app.initGameVars(vars);
            vars.forEach((BiConsumer)new BiConsumer<String, Object>(this){
                final /* synthetic */ InitAppTask this$0;

                public final void accept(@NotNull String name, @NotNull Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    InitAppTask.access$getApp$p(this.this$0).getGameState().put(name, value);
                }
                {
                    this.this$0 = initAppTask;
                }
            });
            Class clazz = (Class)CollectionsKt.firstOrNull(InitAppTask.Companion.getAnnotationParser().getClasses(SetEntityFactory.class));
            if (clazz != null) {
                Class clazz2;
                Class it = clazz2 = clazz;
                Object t = FXGL.Companion.getInstance(it);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.entity.EntityFactory");
                }
                this.app.getGameWorld().setEntityFactory((EntityFactory)t);
            }
            if (this.dataFile == DataFile.Companion.getEMPTY()) {
                this.app.initGame();
            } else {
                this.app.loadState(this.dataFile);
            }
        }

        private final void initPhysics() {
            this.update("Initializing Physics", 2);
            this.app.initPhysics();
            Iterable $receiver$iv = InitAppTask.Companion.getAnnotationParser().getClasses(AddCollisionHandler.class);
            for (Object element$iv : $receiver$iv) {
                Class it = (Class)element$iv;
                Object t = FXGL.Companion.getInstance(it);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.physics.CollisionHandler");
                }
                this.app.getPhysicsWorld().addCollisionHandler((CollisionHandler)t);
            }
        }

        private final void initUI() {
            this.update("Initializing UI", 3);
            this.app.initUI();
        }

        private final void initComplete() {
            this.update("Initialization Complete", 4);
        }

        private final void update(String message2, int step) {
            InitAppTask.Companion.getLog().debug(message2);
            this.updateMessage(message2);
            this.updateProgress(step, 4L);
        }

        protected void failed() {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread thread = Thread.currentThread();
            Throwable throwable = this.getException();
            if (throwable == null) {
                throwable = new RuntimeException("Initialization failed");
            }
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
        }

        public InitAppTask(@NotNull GameApplication app, @NotNull DataFile dataFile) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
            Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
            this.app = app;
            this.dataFile = dataFile;
        }

        static {
            Companion = new Companion(null);
            log = Logger.Companion.get(InitAppTask.class);
            annotationParser = new AnnotationParser(((Object)((Object)FXGL.Companion.getApp())).getClass());
            InitAppTask.Companion.getAnnotationParser().parse(SetEntityFactory.class, AddCollisionHandler.class);
        }

        @NotNull
        public static final /* synthetic */ GameApplication access$getApp$p(InitAppTask $this) {
            return $this.app;
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/app/LoadingState$InitAppTask$Companion;", "", "()V", "annotationParser", "Lcom/almasb/fxgl/annotation/AnnotationParser;", "getAnnotationParser", "()Lcom/almasb/fxgl/annotation/AnnotationParser;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getLog", "()Lcom/almasb/fxgl/core/logging/Logger;", "fxgl"})
        public static final class Companion {
            private final Logger getLog() {
                return log;
            }

            private final AnnotationParser getAnnotationParser() {
                return annotationParser;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

