/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.logging;

import com.almasb.fxgl.core.logging.FileOutput;
import com.almasb.fxgl.core.logging.LoggerOutput;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/core/logging/FileOutput;", "Lcom/almasb/fxgl/core/logging/LoggerOutput;", "baseFileName", "", "logDirectory", "maxLogFiles", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "append", "", "message", "cleanOldLogs", "close", "fxgl"})
public final class FileOutput
implements LoggerOutput {
    private final ArrayList<String> data;
    private final String baseFileName;
    private final String logDirectory;
    private final int maxLogFiles;

    @Override
    public void append(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.data.add(message2);
    }

    @Override
    public void close() {
        String stamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MMM-yyyy-HH.mm.ss"));
        Path file = Paths.get("" + this.logDirectory + "" + this.baseFileName + '-' + stamp, new String[0]);
        Files.write(file, (Iterable<? extends CharSequence>)this.data, new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanOldLogs() {
        int n;
        int n2;
        List logs2;
        int logSize;
        Path logDir = Paths.get(this.logDirectory, new String[0]);
        if (!Files.exists(logDir, new LinkOption[0])) {
            Files.createDirectory(logDir, new FileAttribute[0]);
            Path readmeFile = Paths.get("" + this.logDirectory + "Readme.txt", new String[0]);
            Files.write(readmeFile, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)("This directory contains " + this.baseFileName + " log files.")), new OpenOption[0]);
        }
        if ((logSize = (logs2 = Files.walk(logDir, 1, new FileVisitOption[0]).filter(cleanOldLogs.logs.1.INSTANCE).sorted(cleanOldLogs.logs.2.INSTANCE).collect(Collectors.toList())).size()) >= this.maxLogFiles && (n2 = 0) <= (n = logSize + 1 - this.maxLogFiles - 1)) {
            while (true) {
                void i;
                Files.delete((Path)logs2.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
    }

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName, @NotNull String logDirectory, int maxLogFiles) {
        Intrinsics.checkParameterIsNotNull((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkParameterIsNotNull((Object)logDirectory, (String)"logDirectory");
        this.baseFileName = baseFileName;
        this.logDirectory = logDirectory;
        this.maxLogFiles = maxLogFiles;
        FileOutput fileOutput = this;
        ArrayList arrayList = new ArrayList();
        fileOutput.data = arrayList;
        this.cleanOldLogs();
    }

    @JvmOverloads
    public /* synthetic */ FileOutput(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "logs/";
        }
        if ((n2 & 4) != 0) {
            n = 10;
        }
        this(string, string2, n);
    }

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName, @NotNull String logDirectory) {
        this(baseFileName, logDirectory, 0, 4, null);
    }

    @JvmOverloads
    public FileOutput(@NotNull String baseFileName) {
        this(baseFileName, null, 0, 6, null);
    }
}

