/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.ecs.Control;
import com.almasb.fxgl.ecs.Entity;
import com.almasb.fxgl.ecs.component.Required;
import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.effect.ParticleEmitter;
import com.almasb.fxgl.entity.component.PositionComponent;
import java.util.Iterator;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;

@Required(value=PositionComponent.class)
public class ParticleControl
extends Control {
    private ParticleEmitter emitter;
    protected Array<Particle> particles = new UnorderedArray<Particle>(256);
    private PositionComponent position;

    public ParticleControl(ParticleEmitter emitter) {
        this.emitter = emitter;
    }

    protected ParticleControl() {
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        if (this.emitter == null) {
            return;
        }
        this.particles.addAll(this.emitter.emit(this.position.getX(), this.position.getY()));
        Iterator<Particle> it = this.particles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            if (!p.update(tpf)) continue;
            it.remove();
            Pools.free(p);
        }
    }

    @Override
    public void onRemoved(Entity entity) {
        this.particles.clear();
    }

    public void renderParticles(GraphicsContext g, Point2D viewportOrigin) {
        for (Particle p : this.particles) {
            p.render(g, viewportOrigin);
        }
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }
}

