/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay.rpg;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.gameplay.rpg.InGameClock;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00018B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0013\u0010$\u001a\n %*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\n %*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\u0002\u0010&J\u0013\u0010(\u001a\n %*\u0004\u0018\u00010\u001b0\u001b\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0019H\u0016J\u001e\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0016\u00103\u001a\u00020,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0003J\u0006\u00104\u001a\u00020,J\u0006\u00105\u001a\u00020,J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u00106\u001a\u00020,H\u0002J\b\u00107\u001a\u00020,H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u0004R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\u0004R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/almasb/fxgl/gameplay/rpg/InGameClock;", "Lcom/almasb/fxgl/app/listener/StateListener;", "secondsIn24h", "", "(I)V", "actions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/almasb/fxgl/gameplay/rpg/InGameClock$ClockAction;", "dayTimeStart", "getDayTimeStart", "()I", "setDayTimeStart", "gameHour", "Ljavafx/beans/property/ReadOnlyIntegerWrapper;", "gameMinute", "<set-?>", "gameSecond", "getGameSecond", "setGameSecond", "isDayTime", "Ljavafx/beans/property/ReadOnlyBooleanWrapper;", "nightTimeStart", "getNightTimeStart", "setNightTimeStart", "seconds", "", "started", "", "textView", "Ljavafx/scene/text/Text;", "toGameSeconds", "dayProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "gameHourProperty", "Ljavafx/beans/property/ReadOnlyIntegerProperty;", "gameMinuteProperty", "getGameHour", "kotlin.jvm.PlatformType", "()Ljava/lang/Integer;", "getGameMinute", "isDay", "()Ljava/lang/Boolean;", "isNight", "onUpdate", "", "tpf", "runAt", "action", "Ljava/lang/Runnable;", "hour", "minute", "runAtHour", "start", "stop", "updateActions", "updateView", "ClockAction", "fxgl"})
public final class InGameClock
implements StateListener {
    private double seconds;
    private final ReadOnlyIntegerWrapper gameHour = new ReadOnlyIntegerWrapper();
    private final ReadOnlyIntegerWrapper gameMinute = new ReadOnlyIntegerWrapper();
    private int gameSecond;
    private final double toGameSeconds;
    private Text textView;
    private int dayTimeStart;
    private int nightTimeStart;
    private final ReadOnlyBooleanWrapper isDayTime;
    private boolean started;
    private final CopyOnWriteArrayList<ClockAction> actions;

    @NotNull
    public final ReadOnlyIntegerProperty gameHourProperty() {
        ReadOnlyIntegerProperty readOnlyIntegerProperty = this.gameHour.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyIntegerProperty, (String)"gameHour.readOnlyProperty");
        return readOnlyIntegerProperty;
    }

    @NotNull
    public final ReadOnlyIntegerProperty gameMinuteProperty() {
        ReadOnlyIntegerProperty readOnlyIntegerProperty = this.gameMinute.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyIntegerProperty, (String)"gameMinute.readOnlyProperty");
        return readOnlyIntegerProperty;
    }

    public final Integer getGameHour() {
        return this.gameHour.getValue();
    }

    public final Integer getGameMinute() {
        return this.gameMinute.getValue();
    }

    public final int getGameSecond() {
        return this.gameSecond;
    }

    private final void setGameSecond(int n) {
        this.gameSecond = n;
    }

    @Override
    public void onUpdate(double tpf) {
        this.seconds += tpf;
        double totalGameSeconds = this.seconds * this.toGameSeconds;
        if (totalGameSeconds > (double)86400) {
            this.seconds = 0.0;
            totalGameSeconds = 0.0;
        }
        this.gameHour.setValue((Number)((int)totalGameSeconds / 3600));
        this.gameMinute.setValue((Number)((int)totalGameSeconds / 60 % 60));
        this.gameSecond = (int)totalGameSeconds % 60;
        int n = this.dayTimeStart;
        IntRange intRange = new IntRange(n, this.nightTimeStart - 1);
        Integer n2 = this.gameHour.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"gameHour.value");
        this.isDayTime.setValue(Boolean.valueOf(intRange.contains(n2.intValue())));
        this.updateActions();
        this.updateView();
    }

    public final int getDayTimeStart() {
        return this.dayTimeStart;
    }

    public final void setDayTimeStart(int n) {
        this.dayTimeStart = n;
    }

    public final int getNightTimeStart() {
        return this.nightTimeStart;
    }

    public final void setNightTimeStart(int n) {
        this.nightTimeStart = n;
    }

    @NotNull
    public final ReadOnlyBooleanProperty dayProperty() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = this.isDayTime.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyBooleanProperty, (String)"isDayTime.readOnlyProperty");
        return readOnlyBooleanProperty;
    }

    public final Boolean isDay() {
        return this.isDayTime.getValue();
    }

    public final boolean isNight() {
        return this.isDay() == false;
    }

    public final void start() {
        if (!this.started) {
            FXGL.Companion.getApp().addPlayStateListener(this);
            this.started = true;
        }
    }

    public final void stop() {
        if (this.started) {
            FXGL.Companion.getApp().removePlayStateListener(this);
            this.started = false;
        }
    }

    @NotNull
    public final Text textView() {
        if (this.textView == null) {
            this.textView = FXGL.Companion.getUIFactory().newText("", Color.BLACK, 16.0);
        }
        Text text = this.textView;
        if (text == null) {
            Intrinsics.throwNpe();
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateActions() {
        ClockAction it;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.actions;
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ClockAction)element$iv$iv;
            if (!(Intrinsics.compare((int)this.gameHour.getValue(), (int)it.getHour()) > 0 || Intrinsics.areEqual((Object)this.gameHour.getValue(), (Object)it.getHour()) && Intrinsics.compare((int)this.gameMinute.getValue(), (int)it.getMinute()) >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv;
        Iterable $receiver$iv2 = object;
        for (Object element$iv : $receiver$iv2) {
            it = (ClockAction)element$iv;
            it.setDone(true);
        }
        $receiver$iv = object;
        for (Object element$iv : $receiver$iv) {
            ClockAction it2 = (ClockAction)element$iv;
            it2.getAction().run();
        }
        this.actions.removeIf(updateActions.4.INSTANCE);
    }

    private final void updateView() {
        block0: {
            Text text;
            Text text2 = this.textView;
            if (text2 == null) break block0;
            Text $receiver = text = text2;
            String hour = StringsKt.padStart((String)("" + this.gameHour.getValue()), (int)2, (char)'0');
            String min = StringsKt.padStart((String)("" + this.gameMinute.getValue()), (int)2, (char)'0');
            $receiver.setText("" + hour + ':' + min);
        }
    }

    public final void runAtHour(@NotNull Runnable action2, int hour) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        this.runAt(action2, hour, 0);
    }

    public final void runAt(@NotNull Runnable action2, int hour, int minute) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        this.actions.add(new ClockAction(hour, minute, action2, false, 8, null));
    }

    @Inject
    public InGameClock(@Named(value="gameplay.clock.secondsIn24h") int secondsIn24h) {
        this.toGameSeconds = 86400.0 / (double)secondsIn24h;
        this.dayTimeStart = 8;
        this.nightTimeStart = 20;
        this.isDayTime = new ReadOnlyBooleanWrapper(false);
        this.actions = new CopyOnWriteArrayList();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/gameplay/rpg/InGameClock$ClockAction;", "", "hour", "", "minute", "action", "Ljava/lang/Runnable;", "done", "", "(IILjava/lang/Runnable;Z)V", "getAction", "()Ljava/lang/Runnable;", "setAction", "(Ljava/lang/Runnable;)V", "getDone", "()Z", "setDone", "(Z)V", "getHour", "()I", "setHour", "(I)V", "getMinute", "setMinute", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "fxgl"})
    private static final class ClockAction {
        private int hour;
        private int minute;
        @NotNull
        private Runnable action;
        private boolean done;

        public final int getHour() {
            return this.hour;
        }

        public final void setHour(int n) {
            this.hour = n;
        }

        public final int getMinute() {
            return this.minute;
        }

        public final void setMinute(int n) {
            this.minute = n;
        }

        @NotNull
        public final Runnable getAction() {
            return this.action;
        }

        public final void setAction(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"<set-?>");
            this.action = runnable;
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        public ClockAction(int hour, int minute, @NotNull Runnable action2, boolean done) {
            Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
            this.hour = hour;
            this.minute = minute;
            this.action = action2;
            this.done = done;
        }

        public /* synthetic */ ClockAction(int n, int n2, Runnable runnable, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                bl = false;
            }
            this(n, n2, runnable, bl);
        }

        public final int component1() {
            return this.hour;
        }

        public final int component2() {
            return this.minute;
        }

        @NotNull
        public final Runnable component3() {
            return this.action;
        }

        public final boolean component4() {
            return this.done;
        }

        @NotNull
        public final ClockAction copy(int hour, int minute, @NotNull Runnable action2, boolean done) {
            Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
            return new ClockAction(hour, minute, action2, done);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClockAction copy$default(ClockAction clockAction, int n, int n2, Runnable runnable, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = clockAction.hour;
            }
            if ((n3 & 2) != 0) {
                n2 = clockAction.minute;
            }
            if ((n3 & 4) != 0) {
                runnable = clockAction.action;
            }
            if ((n3 & 8) != 0) {
                bl = clockAction.done;
            }
            return clockAction.copy(n, n2, runnable, bl);
        }

        public String toString() {
            return "ClockAction(hour=" + this.hour + ", minute=" + this.minute + ", action=" + this.action + ", done=" + this.done + ")";
        }

        public int hashCode() {
            Runnable runnable = this.action;
            int n = ((this.hour * 31 + this.minute) * 31 + (runnable != null ? runnable.hashCode() : 0)) * 31;
            int n2 = this.done ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClockAction)) break block3;
                    ClockAction clockAction = (ClockAction)object;
                    if (!(this.hour == clockAction.hour) || !(this.minute == clockAction.minute) || !Intrinsics.areEqual((Object)this.action, (Object)clockAction.action) || !(this.done == clockAction.done)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

