/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.Achievement;
import com.almasb.fxgl.gameplay.GameDifficulty;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import com.almasb.fxgl.scene.menu.MenuType;
import com.almasb.fxgl.ui.FXGLSpinner;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public abstract class FXGLMenu
extends FXGLScene {
    protected static final Logger log = Logger.get("FXGL.Menu");
    protected final GameApplication app;
    protected final MenuType type;
    protected MenuEventListener listener;
    protected final Pane menuRoot = new Pane();
    protected final Pane contentRoot = new Pane();
    protected final MenuContent EMPTY = new MenuContent(new Node[0]);

    public FXGLMenu(GameApplication app, MenuType type) {
        this.app = app;
        this.type = type;
        this.listener = app.getMenuListener();
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.createBackground(app.getWidth(), app.getHeight()), this.createTitleView(app.getSettings().getTitle()), this.createVersionView(this.makeVersionString()), this.menuRoot, this.contentRoot});
        this.listener.profileNameProperty().addListener((o, oldName, newName) -> {
            if (!oldName.isEmpty()) {
                this.getContentRoot().getChildren().remove(this.getContentRoot().getChildren().size() - 1);
            }
            this.getContentRoot().getChildren().add((Object)this.createProfileView("Profile: " + newName));
        });
    }

    protected void switchMenuTo(Node menuBox) {
    }

    protected void switchMenuContentTo(Node content) {
    }

    protected abstract Button createActionButton(String var1, Runnable var2);

    protected Button createContentButton(String name, Supplier<MenuContent> contentSupplier) {
        return this.createActionButton(name, () -> this.switchMenuContentTo((Node)contentSupplier.get()));
    }

    private String makeVersionString() {
        return "v" + this.app.getSettings().getVersion() + (this.app.getSettings().getApplicationMode() == ApplicationMode.RELEASE ? "" : "-" + (Object)((Object)this.app.getSettings().getApplicationMode()));
    }

    protected abstract Node createBackground(double var1, double var3);

    protected abstract Node createTitleView(String var1);

    protected abstract Node createVersionView(String var1);

    protected abstract Node createProfileView(String var1);

    protected final MenuContent createContentLoad() {
        log.debug("createContentLoad()");
        ListView list = FXGL.getUIFactory().newListView();
        list.setItems(this.listener.getSaveLoadManager().saveFiles());
        list.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)list.getItems()).multiply(36));
        this.listener.getSaveLoadManager().querySaveFiles();
        Button btnLoad = FXGL.getUIFactory().newButton("LOAD");
        btnLoad.disableProperty().bind((ObservableValue)list.getSelectionModel().selectedItemProperty().isNull());
        btnLoad.setOnAction(e -> {
            SaveFile saveFile = (SaveFile)list.getSelectionModel().getSelectedItem();
            this.fireLoad(saveFile);
        });
        Button btnDelete = FXGL.getUIFactory().newButton("DELETE");
        btnDelete.disableProperty().bind((ObservableValue)list.getSelectionModel().selectedItemProperty().isNull());
        btnDelete.setOnAction(e -> {
            SaveFile saveFile = (SaveFile)list.getSelectionModel().getSelectedItem();
            this.fireDelete(saveFile);
        });
        HBox hbox = new HBox(50.0, new Node[]{btnLoad, btnDelete});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent(new Node[]{list, hbox});
    }

    protected final MenuContent createContentGameplay() {
        log.debug("createContentGameplay()");
        FXGLSpinner difficultySpinner = new FXGLSpinner(FXCollections.observableArrayList((Object[])GameDifficulty.values()));
        difficultySpinner.increment();
        this.app.getGameState().gameDifficultyProperty().bind((ObservableValue)difficultySpinner.valueProperty());
        return new MenuContent(new Node[]{new HBox(25.0, new Node[]{FXGL.getUIFactory().newText("DIFFICULTY:"), difficultySpinner})});
    }

    protected final MenuContent createContentControls() {
        log.debug("createContentControls()");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(50.0);
        grid.setUserData((Object)0);
        this.app.getInput().getBindings().forEach((action2, trigger) -> this.addNewInputBinding((UserAction)action2, grid));
        ScrollPane scroll = new ScrollPane((Node)grid);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scroll.setMaxHeight((double)(this.app.getHeight() / 2));
        scroll.setStyle("-fx-background: black;");
        HBox hbox = new HBox(new Node[]{scroll});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent(new Node[]{hbox});
    }

    private void addNewInputBinding(UserAction action2, GridPane grid) {
        Text actionName = FXGL.getUIFactory().newText(action2.getName());
        Button triggerName = FXGL.getUIFactory().newButton("");
        triggerName.textProperty().bind((ObservableValue)this.app.getInput().triggerNameProperty(action2));
        triggerName.setOnMouseClicked(event -> {
            Rectangle rect = new Rectangle(250.0, 100.0);
            rect.setStroke((Paint)Color.AZURE);
            Text text = FXGL.getUIFactory().newText("PRESS ANY KEY", 24.0);
            Stage stage = new Stage(StageStyle.TRANSPARENT);
            stage.initModality(Modality.WINDOW_MODAL);
            stage.initOwner(this.getRoot().getScene().getWindow());
            Scene scene = new Scene((Parent)new StackPane(new Node[]{rect, text}));
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.CONTROL || e.getCode() == KeyCode.SHIFT || e.getCode() == KeyCode.ALT) {
                    return;
                }
                boolean rebound = this.app.getInput().rebind(action2, e.getCode(), InputModifier.from(e));
                if (rebound) {
                    stage.close();
                }
            });
            scene.setOnMouseClicked(e -> {
                boolean rebound = this.app.getInput().rebind(action2, e.getButton(), InputModifier.from(e));
                if (rebound) {
                    stage.close();
                }
            });
            stage.setScene(scene);
            stage.show();
        });
        int controlsRow = (Integer)grid.getUserData();
        grid.addRow(controlsRow++, new Node[]{actionName, triggerName});
        grid.setUserData((Object)controlsRow);
        GridPane.setHalignment((Node)actionName, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)triggerName, (HPos)HPos.LEFT);
    }

    protected final MenuContent createContentVideo() {
        log.debug("createContentVideo()");
        return new MenuContent(new Node[0]);
    }

    protected final MenuContent createContentAudio() {
        log.debug("createContentAudio()");
        Slider sliderMusic = new Slider(0.0, 1.0, 1.0);
        sliderMusic.valueProperty().bindBidirectional((Property)this.app.getAudioPlayer().globalMusicVolumeProperty());
        Text textMusic = FXGL.getUIFactory().newText("Music Volume: ");
        Text percentMusic = FXGL.getUIFactory().newText("");
        percentMusic.textProperty().bind((ObservableValue)sliderMusic.valueProperty().multiply(100).asString("%.0f"));
        Slider sliderSound = new Slider(0.0, 1.0, 1.0);
        sliderSound.valueProperty().bindBidirectional((Property)this.app.getAudioPlayer().globalSoundVolumeProperty());
        Text textSound = FXGL.getUIFactory().newText("Sound Volume: ");
        Text percentSound = FXGL.getUIFactory().newText("");
        percentSound.textProperty().bind((ObservableValue)sliderSound.valueProperty().multiply(100).asString("%.0f"));
        HBox hboxMusic = new HBox(15.0, new Node[]{textMusic, sliderMusic, percentMusic});
        HBox hboxSound = new HBox(15.0, new Node[]{textSound, sliderSound, percentSound});
        hboxMusic.setAlignment(Pos.CENTER_RIGHT);
        hboxSound.setAlignment(Pos.CENTER_RIGHT);
        return new MenuContent(new Node[]{hboxMusic, hboxSound});
    }

    protected final MenuContent createContentCredits() {
        log.debug("createContentCredits()");
        ScrollPane pane = new ScrollPane();
        pane.setPrefWidth((double)(this.app.getWidth() * 3 / 5));
        pane.setPrefHeight((double)(this.app.getHeight() / 2));
        pane.setStyle("-fx-background:black;");
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER);
        vbox.setPrefWidth(pane.getPrefWidth() - 15.0);
        FXGL.getSettings().getCredits().getList().stream().map(FXGL.getUIFactory()::newText).forEach(arg_0 -> vbox.getChildren().add(arg_0));
        pane.setContent((Node)vbox);
        return new MenuContent(new Node[]{pane});
    }

    protected final MenuContent createContentFeedback() {
        log.debug("createContentFeedback()");
        Consumer<String> openBrowser = url -> FXGL.getNet().openBrowserTask(FXGL.getString(url)).onFailure(error -> log.warning("Error opening browser: " + error)).execute();
        Button btnGoogle = new Button("Google Forms");
        btnGoogle.setOnAction(e -> openBrowser.accept("url.googleforms"));
        Button btnSurveyMonkey = new Button("Survey Monkey");
        btnSurveyMonkey.setOnAction(e -> openBrowser.accept("url.surveymonkey"));
        VBox vbox = new VBox(15.0, new Node[]{FXGL.getUIFactory().newText("Choose your feedback method", Color.WHEAT, 18.0), btnGoogle, btnSurveyMonkey});
        vbox.setAlignment(Pos.CENTER);
        return new MenuContent(new Node[]{vbox});
    }

    protected final MenuContent createContentAchievements() {
        log.debug("createContentAchievements()");
        MenuContent content = new MenuContent(new Node[0]);
        for (Achievement a : this.app.getGameplay().getAchievementManager().getAchievements()) {
            CheckBox checkBox = new CheckBox();
            checkBox.setDisable(true);
            checkBox.selectedProperty().bind((ObservableValue)a.achievedProperty());
            Text text = FXGL.getUIFactory().newText(a.getName());
            Tooltip.install((Node)text, (Tooltip)new Tooltip(a.getDescription()));
            HBox box = new HBox(25.0, new Node[]{text, checkBox});
            box.setAlignment(Pos.CENTER_RIGHT);
            content.getChildren().add((Object)box);
        }
        return content;
    }

    protected final void addUINode(Node node) {
        this.getContentRoot().getChildren().add((Object)node);
    }

    protected final void fireNewGame() {
        log.debug("fireNewGame()");
        this.listener.onNewGame();
    }

    protected final void fireContinue() {
        log.debug("fireContinue()");
        this.listener.onContinue();
    }

    protected final void fireLoad(SaveFile fileName) {
        log.debug("fireLoad()");
        this.listener.onLoad(fileName);
    }

    protected final void fireSave() {
        log.debug("fireSave()");
        this.listener.onSave();
    }

    protected final void fireDelete(SaveFile fileName) {
        log.debug("fireDelete()");
        this.listener.onDelete(fileName);
    }

    protected final void fireResume() {
        log.debug("fireResume()");
        this.listener.onResume();
    }

    protected final void fireLogout() {
        log.debug("fireLogout()");
        this.switchMenuContentTo((Node)this.EMPTY);
        this.listener.onLogout();
    }

    protected final void fireMultiplayer() {
        log.debug("fireMultiplayer()");
        this.listener.onMultiplayer();
    }

    protected final void fireExit() {
        log.debug("fireExit()");
        this.listener.onExit();
    }

    protected final void fireExitToMainMenu() {
        log.debug("fireExitToMainMenu()");
        this.listener.onExitToMainMenu();
    }

    protected static class MenuContent
    extends VBox {
        private Runnable onOpen = null;
        private Runnable onClose = null;

        public MenuContent(Node ... items) {
            if (items.length > 0) {
                int maxW = Arrays.stream(items).mapToInt(n -> (int)n.getLayoutBounds().getWidth()).max().orElse(0);
                this.getChildren().add((Object)this.createSeparator(maxW));
                for (Node item : items) {
                    this.getChildren().addAll((Object[])new Node[]{item, this.createSeparator(maxW)});
                }
            }
            this.sceneProperty().addListener((o, oldScene, newScene) -> {
                if (newScene != null) {
                    this.onOpen();
                } else {
                    this.onClose();
                }
            });
        }

        private Line createSeparator(int width) {
            Line sep = new Line();
            sep.setEndX((double)width);
            sep.setStroke((Paint)Color.DARKGREY);
            return sep;
        }

        public void setOnOpen(Runnable onOpenAction) {
            this.onOpen = onOpenAction;
        }

        public void setOnClose(Runnable onCloseAction) {
            this.onClose = onCloseAction;
        }

        private void onOpen() {
            if (this.onOpen != null) {
                this.onOpen.run();
            }
        }

        private void onClose() {
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }
}

